/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.ChannelHandler;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.packstream.ChunkedOutput;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarksParserV3;
import org.neo4j.logging.internal.LogService;

public abstract class AbstractBoltProtocol
implements BoltProtocol {
    private final BoltChannel channel;
    private final LogService logging;
    private final TransportThrottleGroup throttleGroup;
    private final ChannelProtector channelProtector;
    private final BoltStateMachineFactory stateMachineFactory;
    private final BoltConnectionFactory connectionFactory;
    private final BookmarksParser bookmarksParser;

    public AbstractBoltProtocol(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, LogService logging, TransportThrottleGroup throttleGroup, ChannelProtector channelProtector) {
        this(channel, connectionFactory, stateMachineFactory, BookmarksParserV3.INSTANCE, logging, throttleGroup, channelProtector);
    }

    protected AbstractBoltProtocol(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, BookmarksParser bookmarksParser, LogService logging, TransportThrottleGroup throttleGroup, ChannelProtector channelProtector) {
        this.channel = channel;
        this.logging = logging;
        this.throttleGroup = throttleGroup;
        this.stateMachineFactory = stateMachineFactory;
        this.connectionFactory = connectionFactory;
        this.bookmarksParser = bookmarksParser;
        this.channelProtector = channelProtector;
    }

    @Override
    public void install() {
        BoltStateMachine stateMachine = this.stateMachineFactory.newStateMachine(this.version(), this.channel);
        Neo4jPack neo4jPack = this.createPack();
        BoltResponseMessageWriter messageWriter = this.createMessageWriter(neo4jPack, this.logging);
        BoltConnection connection = this.connectionFactory.newConnection(this.channel, stateMachine, messageWriter);
        BoltRequestMessageReader messageReader = this.createMessageReader(connection, messageWriter, this.bookmarksParser, this.logging, this.channelProtector);
        this.channel.installBoltProtocol(new ChannelHandler[]{new ChunkDecoder(), new MessageAccumulator(), new MessageDecoder(neo4jPack, messageReader, this.logging), new HouseKeeper(connection, this.logging.getInternalLog(HouseKeeper.class))});
    }

    protected PackOutput createPackOutput() {
        return new ChunkedOutput(this.channel.rawChannel(), this.throttleGroup);
    }

    protected abstract Neo4jPack createPack();

    protected abstract BoltRequestMessageReader createMessageReader(BoltConnection var1, BoltResponseMessageWriter var2, BookmarksParser var3, LogService var4, ChannelProtector var5);

    protected abstract BoltResponseMessageWriter createMessageWriter(Neo4jPack var1, LogService var2);
}

