/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.time.Duration;
import org.neo4j.bolt.transport.pipeline.AuthenticationTimeoutHandler;
import org.neo4j.bolt.transport.pipeline.BytesAccumulator;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;

public class UnauthenticatedChannelProtector
implements ChannelProtector {
    private final Channel channel;
    private final long maxMessageSize;
    private AuthenticationTimeoutHandler timeoutHandler;

    public UnauthenticatedChannelProtector(Channel ch, Duration channelTimeout, long maxMessageSize) {
        this.channel = ch;
        this.maxMessageSize = maxMessageSize;
        this.timeoutHandler = new AuthenticationTimeoutHandler(channelTimeout);
    }

    @Override
    public void afterChannelCreated() {
        this.channel.pipeline().addLast(new ChannelHandler[]{this.timeoutHandler});
    }

    @Override
    public void beforeBoltProtocolInstalled() {
        this.channel.pipeline().addLast(new ChannelHandler[]{new BytesAccumulator(this.maxMessageSize)});
    }

    @Override
    public void afterRequestReceived() {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.setRequestReceived(true);
        }
    }

    @Override
    public void disable() {
        if (!this.channel.isActive()) {
            return;
        }
        this.channel.pipeline().remove(AuthenticationTimeoutHandler.class);
        this.timeoutHandler = null;
        this.channel.pipeline().remove(BytesAccumulator.class);
    }
}

