/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.util.Map;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class BoltAuthenticationHelper {
    public static boolean processAuthentication(String userAgent, Map<String, Object> authToken, StateMachineContext context, RoutingContext routingContext) throws BoltConnectionFatality {
        try {
            BoltStateMachineSPI boltSpi = context.boltSpi();
            AuthenticationResult authResult = boltSpi.authenticate(authToken);
            String username = authResult.getLoginContext().subject().username();
            context.authenticatedAsUser(username, userAgent);
            context.initStatementProcessorProvider(authResult, routingContext);
            if (authResult.credentialsExpired()) {
                context.connectionState().onMetadata("credentials_expired", (AnyValue)Values.TRUE);
            }
            context.connectionState().onMetadata("server", (AnyValue)Values.utf8Value((String)boltSpi.version()));
            return true;
        }
        catch (Throwable t) {
            context.handleFailure(t, true);
            return false;
        }
    }
}

