/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.DefaultFileSystemWatcher;
import org.neo4j.io.fs.watcher.FileWatcher;

public class DefaultFileSystemAbstraction
implements FileSystemAbstraction {
    static final String UNABLE_TO_CREATE_DIRECTORY_FORMAT = "Unable to write directory path [%s] for Neo4j store.";
    public static final Set<OpenOption> WRITE_OPTIONS = Set.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final Set<OpenOption> READ_OPTIONS = Set.of(StandardOpenOption.READ);
    private static final OpenOption[] APPEND_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    private static final OpenOption[] DEFAULT_OUTPUT_OPTIONS = new OpenOption[0];

    @Override
    public FileWatcher fileWatcher() throws IOException {
        WatchService watchService = FileSystems.getDefault().newWatchService();
        return new DefaultFileSystemWatcher(watchService);
    }

    @Override
    public StoreFileChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        FileChannel channel = FileChannel.open(fileName, options, new FileAttribute[0]);
        return this.getStoreFileChannel(channel);
    }

    @Override
    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        return new BufferedOutputStream(this.openFileOutputStream(fileName, append));
    }

    @Override
    public InputStream openAsInputStream(Path fileName) throws IOException {
        return new BufferedInputStream(DefaultFileSystemAbstraction.openFileInputStream(fileName));
    }

    @Override
    public Reader openAsReader(Path fileName, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(DefaultFileSystemAbstraction.openFileInputStream(fileName), charset));
    }

    @Override
    public Writer openAsWriter(Path fileName, Charset charset, boolean append) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(this.openFileOutputStream(fileName, append), charset));
    }

    @Override
    public StoreFileChannel write(Path fileName) throws IOException {
        return this.open(fileName, (Set)WRITE_OPTIONS);
    }

    @Override
    public StoreFileChannel read(Path fileName) throws IOException {
        return this.open(fileName, (Set)READ_OPTIONS);
    }

    @Override
    public boolean mkdir(Path fileName) {
        try {
            Files.createDirectories(fileName, new FileAttribute[0]);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void mkdirs(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IOException(String.format(UNABLE_TO_CREATE_DIRECTORY_FORMAT, file), e);
        }
    }

    @Override
    public boolean fileExists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    @Override
    public long getFileSize(Path file) {
        try {
            return Files.size(file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public long getBlockSize(Path file) throws IOException {
        return FileUtils.blockSize(file);
    }

    @Override
    public boolean deleteFile(Path fileName) {
        try {
            FileUtils.deleteFile(fileName);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void deleteRecursively(Path directory) throws IOException {
        FileUtils.deleteDirectory(directory);
    }

    @Override
    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        Files.move(from, to, copyOptions);
    }

    @Override
    public Path[] listFiles(Path directory) {
        Path[] pathArray;
        block8: {
            Stream<Path> list = Files.list(directory);
            try {
                pathArray = (Path[])list.toArray(Path[]::new);
                if (list == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            list.close();
        }
        return pathArray;
    }

    @Override
    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) {
        Path[] pathArray;
        block8: {
            DirectoryStream<Path> paths = Files.newDirectoryStream(directory, filter);
            try {
                pathArray = (Path[])StreamSupport.stream(paths.spliterator(), false).toArray(Path[]::new);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            paths.close();
        }
        return pathArray;
    }

    @Override
    public boolean isDirectory(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    @Override
    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        FileUtils.moveFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        FileUtils.copyFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyFile(Path from, Path to) throws IOException {
        FileUtils.copyFile(from, to);
    }

    @Override
    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        FileUtils.copyFile(from, to, copyOptions);
    }

    @Override
    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        FileUtils.copyDirectory(fromDirectory, toDirectory);
    }

    @Override
    public void truncate(Path path, long size) throws IOException {
        FileUtils.truncateFile(path, size);
    }

    @Override
    public long lastModifiedTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public void deleteFileOrThrow(Path file) throws IOException {
        Files.delete(file);
    }

    @Override
    public Stream<FileHandle> streamFilesRecursive(Path directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive(directory, this);
    }

    @Override
    public int getFileDescriptor(StoreChannel channel) {
        return channel.getFileDescriptor();
    }

    @Override
    public void close() throws IOException {
    }

    protected StoreFileChannel getStoreFileChannel(FileChannel channel) {
        return new StoreFileChannel(channel);
    }

    private static InputStream openFileInputStream(Path fileName) throws IOException {
        return Files.newInputStream(fileName, new OpenOption[0]);
    }

    private OutputStream openFileOutputStream(Path fileName, boolean append) throws IOException {
        return Files.newOutputStream(fileName, append ? APPEND_OPTIONS : DEFAULT_OUTPUT_OPTIONS);
    }
}

