/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.concurrent.BinaryLatch;

final class LatchMap {
    private static final int faultLockStriping = FeatureToggles.getInteger(LatchMap.class, (String)"faultLockStriping", (int)128);
    private static final long faultLockMask = faultLockStriping - 1;
    private static final int latchesArrayBase = UnsafeUtil.arrayBaseOffset(Latch[].class);
    private static final int latchesArrayScale = UnsafeUtil.arrayIndexScale(Latch[].class);
    private final Latch[] latches = new Latch[faultLockStriping];

    LatchMap() {
    }

    private long offset(int index) {
        return UnsafeUtil.arrayOffset((int)index, (int)latchesArrayBase, (int)latchesArrayScale);
    }

    private void setLatch(int index, BinaryLatch newValue) {
        UnsafeUtil.putObjectVolatile((Object)this.latches, (long)this.offset(index), (Object)newValue);
    }

    private boolean compareAndSetLatch(int index, Latch expected, Latch update) {
        return UnsafeUtil.compareAndSwapObject((Object)this.latches, (long)this.offset(index), (Object)((Object)expected), (Object)((Object)update));
    }

    private Latch getLatch(int index) {
        return (Latch)((Object)UnsafeUtil.getObjectVolatile((Object)this.latches, (long)this.offset(index)));
    }

    Latch takeOrAwaitLatch(long identifier) {
        int index = this.index(identifier);
        Latch latch = this.getLatch(index);
        while (latch == null) {
            latch = new Latch();
            if (this.compareAndSetLatch(index, null, latch)) {
                latch.latchMap = this;
                latch.index = index;
                return latch;
            }
            latch = this.getLatch(index);
        }
        latch.await();
        return null;
    }

    private int index(long identifier) {
        return (int)(this.mix(identifier) & faultLockMask);
    }

    private long mix(long identifier) {
        identifier ^= identifier << 21;
        identifier ^= identifier >>> 35;
        identifier ^= identifier << 4;
        return identifier;
    }

    static final class Latch
    extends BinaryLatch {
        private LatchMap latchMap;
        private int index;

        Latch() {
        }

        public void release() {
            this.latchMap.setLatch(this.index, null);
            super.release();
        }
    }
}

