/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    MuninnWritePageCursor(long victimPage, PageCursorTracer pageCursorTracer, VersionContextSupplier versionContextSupplier) {
        super(victimPage, pageCursorTracer, versionContextSupplier);
    }

    @Override
    protected void unpinCurrentPage() {
        long pageRef = this.pinnedPageRef;
        if (pageRef != 0L) {
            this.pinEvent.done();
            if (this.eagerFlush) {
                this.eagerlyFlushAndUnlockPage(pageRef);
            } else {
                this.pagedFile.unlockWrite(pageRef);
            }
        }
        this.clearPageCursorState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerlyFlushAndUnlockPage(long pageRef) {
        long flushStamp = this.pagedFile.unlockWriteAndTryTakeFlushLock(pageRef);
        if (flushStamp != 0L) {
            boolean success = false;
            try {
                success = this.pagedFile.flushLockedPage(pageRef, this.loadPlainCurrentPageId());
            }
            finally {
                this.pagedFile.unlockFlush(pageRef, flushStamp, success);
            }
        }
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId < 0L) {
            this.storeCurrentPageId(-1L);
            return false;
        }
        if (this.nextPageId > lastPageId) {
            if (this.noGrow) {
                this.storeCurrentPageId(-1L);
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.storeCurrentPageId(this.nextPageId);
        ++this.nextPageId;
        long filePageId = this.loadPlainCurrentPageId();
        this.pinEvent = this.tracer.beginPin(true, filePageId, this.swapper);
        this.pin(filePageId);
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        return this.pagedFile.tryWriteLock(pageRef);
    }

    @Override
    protected void unlockPage(long pageRef) {
        this.pagedFile.unlockWrite(pageRef);
    }

    @Override
    protected void pinCursorToPage(long pageRef, long filePageId, PageSwapper swapper) throws FileIsNotMappedException {
        this.reset(pageRef);
        this.assertPagedFileStillMappedAndGetIdOfLastPage();
        this.pagedFile.incrementUsage(pageRef);
        this.pagedFile.setLastModifiedTxId(pageRef, this.versionContextSupplier.getVersionContext().committingTransactionId());
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        this.pagedFile.unlockExclusiveAndTakeWriteLock(pageRef);
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

