/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.DeletedNodeStillHasRelationshipsException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.util.Preconditions;

class IntegrityValidator {
    private final NeoStores neoStores;
    private IndexUpdateListener indexValidator;

    IntegrityValidator(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    void setIndexValidator(IndexUpdateListener validator) {
        Preconditions.checkState((this.indexValidator == null ? 1 : 0) != 0, (String)("Only supports a single validator. Tried to add " + String.valueOf(validator) + ", but " + String.valueOf(this.indexValidator) + " has already been added"));
        this.indexValidator = validator;
    }

    static void validateNodeRecord(NodeRecord record) throws TransactionFailureException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw new DeletedNodeStillHasRelationshipsException(record.getId());
        }
    }

    void validateTransactionStartKnowledge(long lastCommittedTxWhenTransactionStarted) throws TransactionFailureException {
        long latestConstraintIntroducingTx = this.neoStores.getMetaDataStore().getLatestConstraintIntroducingTx();
        if (lastCommittedTxWhenTransactionStarted < latestConstraintIntroducingTx) {
            throw new TransactionFailureException((Status)Status.Transaction.ConstraintsChanged, "Database constraints have changed (txId=%d) after this transaction (txId=%d) started, which is not yet supported. Please retry your transaction to ensure all constraints are executed.", new Object[]{latestConstraintIntroducingTx, lastCommittedTxWhenTransactionStarted});
        }
    }

    void validateSchemaRule(SchemaRule schemaRule) throws TransactionFailureException {
        ConstraintDescriptor constraint;
        IndexDescriptor index;
        Preconditions.checkState((this.indexValidator != null ? 1 : 0) != 0, (String)"No index validator installed");
        KernelVersion currentVersion = this.neoStores.getMetaDataStore().kernelVersion();
        if (currentVersion.isLessThan(KernelVersion.VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED)) {
            if (schemaRule instanceof IndexDescriptor && ((index = (IndexDescriptor)schemaRule).isTokenIndex() || this.isBtreeRelationshipPropertyIndex(index))) {
                throw new TransactionFailureException((Status)Status.General.UpgradeRequired, "Index operation on index '%s' not allowed. Required kernel version for this transaction is %s, but actual version was %s.", new Object[]{index, KernelVersion.VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED.name(), currentVersion.name()});
            }
        } else if (currentVersion.isLessThan(KernelVersion.VERSION_RANGE_POINT_TEXT_INDEX_TYPES_ARE_INTRODUCED)) {
            if (schemaRule instanceof IndexDescriptor) {
                index = (IndexDescriptor)schemaRule;
                IndexType indexType = index.getIndexType();
                if (this.isRangePointOrTextIndex(indexType)) {
                    throw new TransactionFailureException((Status)Status.General.UpgradeRequired, "Index operation on index '%s' not allowed. Required kernel version for this transaction is %s, but actual version was %s.", new Object[]{index, KernelVersion.VERSION_RANGE_POINT_TEXT_INDEX_TYPES_ARE_INTRODUCED.name(), currentVersion.name()});
                }
            } else if (schemaRule instanceof ConstraintDescriptor && (constraint = (ConstraintDescriptor)schemaRule).isIndexBackedConstraint() && this.isRangePointOrTextIndex(constraint.asIndexBackedConstraint().indexType())) {
                throw new TransactionFailureException((Status)Status.General.UpgradeRequired, "Constraint operation on constraint '%s' not allowed. Required kernel version for this transaction is %s, but actual version was %s.", new Object[]{constraint, KernelVersion.VERSION_RANGE_POINT_TEXT_INDEX_TYPES_ARE_INTRODUCED.name(), currentVersion.name()});
            }
        }
        if (schemaRule instanceof ConstraintDescriptor && (constraint = (ConstraintDescriptor)schemaRule).isIndexBackedConstraint()) {
            long ownedIndex = constraint.asIndexBackedConstraint().ownedIndexId();
            try {
                this.indexValidator.validateIndex(ownedIndex);
            }
            catch (KernelException e) {
                throw new TransactionFailureException((Status)Status.Transaction.TransactionValidationFailed, (Throwable)e, "Index validation of " + String.valueOf(schemaRule) + " failed, specifically for its owned index " + ownedIndex, new Object[]{e});
            }
        }
    }

    private boolean isBtreeRelationshipPropertyIndex(IndexDescriptor index) {
        return index.getIndexType() == IndexType.BTREE && index.schema().isRelationshipTypeSchemaDescriptor();
    }

    private boolean isRangePointOrTextIndex(IndexType indexType) {
        return indexType == IndexType.RANGE || indexType == IndexType.POINT || indexType == IndexType.TEXT;
    }
}

