/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandReading;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.legacy.IndexCommand;
import org.neo4j.internal.recordstorage.legacy.IndexDefineCommand;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.IoPrimitiveUtils;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaRuleSerialization35;
import org.neo4j.util.Bits;
import org.neo4j.util.VisibleForTesting;

class LogCommandSerializationV3_0_10
extends LogCommandSerialization {
    static final LogCommandSerializationV3_0_10 INSTANCE = new LogCommandSerializationV3_0_10();

    LogCommandSerializationV3_0_10() {
    }

    @Override
    KernelVersion version() {
        return KernelVersion.V2_3;
    }

    @Override
    protected Command readNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = LogCommandSerializationV3_0_10.readNodeRecord(id, channel);
        if (before == null) {
            return null;
        }
        NodeRecord after = LogCommandSerializationV3_0_10.readNodeRecord(id, channel);
        if (after == null) {
            return null;
        }
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        return new Command.NodeCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord before = LogCommandSerializationV3_0_10.readRelationshipRecord(id, channel);
        if (before == null) {
            return null;
        }
        RelationshipRecord after = LogCommandSerializationV3_0_10.readRelationshipRecord(id, channel);
        if (after == null) {
            return null;
        }
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        return new Command.RelationshipCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = LogCommandSerializationV3_0_10.readPropertyRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyRecord after = LogCommandSerializationV3_0_10.readPropertyRecord(id, channel);
        if (after == null) {
            return null;
        }
        return new Command.PropertyCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV3_0_10.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV3_0_10.readRelationshipGroupRecord(id, channel);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong(), requireSecondaryUnit);
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = this.readRelationshipGroupExtendedRecord(id, channel);
        RelationshipGroupRecord after = this.readRelationshipGroupExtendedRecord(id, channel);
        return new Command.RelationshipGroupCommand(before, after);
    }

    private RelationshipGroupRecord readRelationshipGroupExtendedRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        type |= Numbers.unsignedByteToInt((byte)channel.get()) << 16;
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong(), requireSecondaryUnit);
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        RelationshipTypeTokenRecord before = LogCommandSerializationV3_0_10.readRelationshipTypeTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        RelationshipTypeTokenRecord after = LogCommandSerializationV3_0_10.readRelationshipTypeTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        return new Command.RelationshipTypeTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipTypeTokenRecord readRelationshipTypeTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LogCommandSerializationV3_0_10.readDynamicRecord(channel);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return record;
    }

    @Override
    protected Command readLabelTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        LabelTokenRecord before = LogCommandSerializationV3_0_10.readLabelTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        LabelTokenRecord after = LogCommandSerializationV3_0_10.readLabelTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        return new Command.LabelTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static LabelTokenRecord readLabelTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LogCommandSerializationV3_0_10.readDynamicRecord(channel);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return record;
    }

    @Override
    protected Command readPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        PropertyKeyTokenRecord before = LogCommandSerializationV3_0_10.readPropertyKeyTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyKeyTokenRecord after = LogCommandSerializationV3_0_10.readPropertyKeyTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        return new Command.PropertyKeyTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static PropertyKeyTokenRecord readPropertyKeyTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(channel.getInt());
        record.setNameId(channel.getInt());
        if (LogCommandSerializationV3_0_10.readDynamicRecords(channel, record, CommandReading.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return record;
    }

    @Override
    protected Command readLegacySchemaRuleCommand(ReadableChannel channel) throws IOException {
        ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
        LogCommandSerializationV3_0_10.readDynamicRecords(channel, recordsBefore, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
        LogCommandSerializationV3_0_10.readDynamicRecords(channel, recordsAfter, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        byte isCreated = channel.get();
        if (1 == isCreated) {
            for (DynamicRecord record : recordsAfter) {
                record.setCreated();
            }
        }
        SchemaRule rule = ((DynamicRecord)Iterables.first(recordsAfter)).inUse() ? LogCommandSerializationV3_0_10.readSchemaRule(recordsAfter) : LogCommandSerializationV3_0_10.readSchemaRule(recordsBefore);
        return new Command.SchemaRuleCommand(this, new SchemaRecord(0L), new SchemaRecord(0L), rule);
    }

    @Override
    protected Command readNeoStoreCommand(ReadableChannel channel) throws IOException {
        NeoStoreRecord before = LogCommandSerializationV3_0_10.readNeoStoreRecord(channel);
        NeoStoreRecord after = LogCommandSerializationV3_0_10.readNeoStoreRecord(channel);
        return new Command.NeoStoreCommand((LogCommandSerialization)this, before, after);
    }

    private static NeoStoreRecord readNeoStoreRecord(ReadableChannel channel) throws IOException {
        long nextProp = channel.getLong();
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(nextProp);
        return record;
    }

    private static NodeRecord readNodeRecord(long id, ReadableChannel channel) throws IOException {
        NodeRecord record;
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = Bits.bitFlag((int)flags, (int)2);
        boolean requiresSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
        long labelField = Record.NO_LABELS_FIELD.intValue();
        if (inUse) {
            boolean dense = channel.get() == 1;
            long nextRel = channel.getLong();
            long nextProp = channel.getLong();
            record = new NodeRecord(id).initialize(false, nextProp, dense, nextRel, 0L);
            labelField = channel.getLong();
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong(), requiresSecondaryUnit);
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new NodeRecord(id);
        }
        LogCommandSerializationV3_0_10.readDynamicRecords(channel, dynamicLabelRecords, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        record.setLabelField(labelField, dynamicLabelRecords);
        record.setInUse(inUse);
        if (isCreated) {
            record.setCreated();
        }
        return record;
    }

    private static RelationshipRecord readRelationshipRecord(long id, ReadableChannel channel) throws IOException {
        RelationshipRecord record;
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requiresSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        if (inUse) {
            record = new RelationshipRecord(id);
            record.setLinks(channel.getLong(), channel.getLong(), channel.getInt());
            record.setInUse(true);
            record.setFirstPrevRel(channel.getLong());
            record.setFirstNextRel(channel.getLong());
            record.setSecondPrevRel(channel.getLong());
            record.setSecondNextRel(channel.getLong());
            record.setNextProp(channel.getLong());
            byte extraByte = channel.get();
            record.setFirstInFirstChain((extraByte & 1) > 0);
            record.setFirstInSecondChain((extraByte & 2) > 0);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong(), requiresSecondaryUnit);
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new RelationshipRecord(id);
            record.setLinks(-1L, -1L, channel.getInt());
            record.setInUse(false);
        }
        if (Bits.bitFlag((int)flags, (int)2)) {
            record.setCreated();
        }
        return record;
    }

    private static DynamicRecord readDynamicRecord(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & 2) != 0);
            int nrOfBytes = channel.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = channel.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    private static <T> int readDynamicRecords(ReadableChannel channel, T target, CommandReading.DynamicRecordAdder<T> adder) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        for (numberOfRecords = channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
            DynamicRecord read = LogCommandSerializationV3_0_10.readDynamicRecord(channel);
            if (read == null) {
                return -1;
            }
            adder.add(target, read);
        }
        return numberOfRecords;
    }

    private static PropertyRecord readPropertyRecord(long id, ReadableChannel channel) throws IOException {
        PropertyRecord record = new PropertyRecord(id);
        byte flags = channel.get();
        boolean inUse = Bits.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean nodeProperty = !Bits.bitFlag((byte)flags, (byte)Record.REL_PROPERTY.byteValue());
        boolean requireSecondaryUnit = Bits.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = Bits.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = Bits.bitFlag((int)flags, (int)16);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        long nextProp = channel.getLong();
        long prevProp = channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        long primitiveId = channel.getLong();
        if (primitiveId != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong(), requireSecondaryUnit);
        }
        int nrPropBlocks = channel.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = LogCommandSerializationV3_0_10.readPropertyBlock(channel);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        int deletedRecords = LogCommandSerializationV3_0_10.readDynamicRecords(channel, record, CommandReading.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER);
        if (deletedRecords == -1) {
            return null;
        }
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = LogCommandSerializationV3_0_10.readDynamicRecord(channel);
            if (read == null) {
                return null;
            }
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + String.valueOf(record));
        }
        return record;
    }

    private static PropertyBlock readPropertyBlock(ReadableChannel channel) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = channel.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        long[] blocks = LogCommandSerializationV3_0_10.readLongs(channel, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyTypeOrThrow(blocks[0]).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + String.valueOf((Object)PropertyType.getPropertyTypeOrThrow(blocks[0]));
        toReturn.setValueBlocks(blocks);
        if (LogCommandSerializationV3_0_10.readDynamicRecords(channel, toReturn, CommandReading.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return toReturn;
    }

    private static long[] readLongs(ReadableChannel channel, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = channel.getLong();
        }
        return result;
    }

    private static SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
        SchemaRule rule;
        ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
        try {
            rule = SchemaRuleSerialization35.deserialize(((DynamicRecord)Iterables.first(recordsBefore)).getId(), deserialized);
        }
        catch (MalformedSchemaRuleException e) {
            return null;
        }
        return rule;
    }

    @Override
    protected Command readIndexAddNodeCommand(ReadableChannel channel) throws IOException {
        IndexCommandHeader header = LogCommandSerializationV3_0_10.readIndexCommandHeader(channel);
        Long entityId = header.entityIdNeedsLong ? channel.getLong() : (long)channel.getInt();
        Object value = LogCommandSerializationV3_0_10.readIndexValue(header.valueType, channel);
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(header.indexNameId, entityId, header.keyId, value);
        return command;
    }

    @Override
    protected Command readIndexAddRelationshipCommand(ReadableChannel channel) throws IOException {
        IndexCommandHeader header = LogCommandSerializationV3_0_10.readIndexCommandHeader(channel);
        Long entityId = header.entityIdNeedsLong ? channel.getLong() : (long)channel.getInt();
        Object value = LogCommandSerializationV3_0_10.readIndexValue(header.valueType, channel);
        Long startNode = header.startNodeNeedsLong ? channel.getLong() : (long)channel.getInt();
        Long endNode = header.endNodeNeedsLong ? channel.getLong() : (long)channel.getInt();
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(header.indexNameId, entityId, header.keyId, value, startNode, endNode);
        return command;
    }

    @Override
    protected Command readIndexRemoveCommand(ReadableChannel channel) throws IOException {
        IndexCommandHeader header = LogCommandSerializationV3_0_10.readIndexCommandHeader(channel);
        Long entityId = header.entityIdNeedsLong ? channel.getLong() : (long)channel.getInt();
        Object value = LogCommandSerializationV3_0_10.readIndexValue(header.valueType, channel);
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(header.indexNameId, header.entityType, entityId, header.keyId, value);
        return command;
    }

    @Override
    protected Command readIndexDeleteCommand(ReadableChannel channel) throws IOException {
        IndexCommandHeader header = LogCommandSerializationV3_0_10.readIndexCommandHeader(channel);
        IndexCommand.DeleteCommand command = new IndexCommand.DeleteCommand();
        command.init(header.indexNameId, header.entityType);
        return command;
    }

    @Override
    protected Command readIndexCreateCommand(ReadableChannel channel) throws IOException {
        IndexCommandHeader header = LogCommandSerializationV3_0_10.readIndexCommandHeader(channel);
        Map config = IoPrimitiveUtils.read2bMap((ReadableChannel)channel);
        IndexCommand.CreateCommand command = new IndexCommand.CreateCommand();
        command.init(header.indexNameId, header.entityType, config);
        return command;
    }

    @Override
    protected Command readIndexDefineCommand(ReadableChannel channel) throws IOException {
        LogCommandSerializationV3_0_10.readIndexCommandHeader(channel);
        MutableObjectIntMap<String> indexNames = LogCommandSerializationV3_0_10.readMap(channel);
        MutableObjectIntMap<String> keys = LogCommandSerializationV3_0_10.readMap(channel);
        IndexDefineCommand command = new IndexDefineCommand();
        command.init(indexNames, keys);
        return command;
    }

    @Override
    protected Command readNodeCountsCommand(ReadableChannel channel) throws IOException {
        int labelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.NodeCountsCommand(this, labelId, delta);
    }

    @Override
    protected Command readRelationshipCountsCommand(ReadableChannel channel) throws IOException {
        int startLabelId = channel.getInt();
        int typeId = channel.getInt();
        int endLabelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.RelationshipCountsCommand(this, startLabelId, typeId, endLabelId, delta);
    }

    @Override
    @VisibleForTesting
    public void writeNeoStoreCommand(WritableChannel channel, Command.NeoStoreCommand command) throws IOException {
        channel.put((byte)6);
        channel.putLong(((NeoStoreRecord)command.before).getNextProp());
        channel.putLong(((NeoStoreRecord)command.after).getNextProp());
    }

    private static MutableObjectIntMap<String> readMap(ReadableChannel channel) throws IOException {
        int size = LogCommandSerializationV3_0_10.getUnsignedShort(channel);
        ObjectIntHashMap result = new ObjectIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            String key = IoPrimitiveUtils.read2bLengthAndString((ReadableChannel)channel);
            int id = LogCommandSerializationV3_0_10.getUnsignedShort(channel);
            if (key == null) {
                return null;
            }
            result.put((Object)key, id);
        }
        return result;
    }

    private static int getUnsignedShort(ReadableChannel channel) throws IOException {
        int result = channel.getShort() & 0xFFFF;
        return result == 65535 ? -1 : result;
    }

    private static IndexCommandHeader readIndexCommandHeader(ReadableChannel channel) throws IOException {
        byte firstHeaderByte = channel.get();
        byte valueType = (byte)((firstHeaderByte & 0x1C) >> 2);
        byte entityType = (byte)((firstHeaderByte & 2) >> 1);
        boolean entityIdNeedsLong = (firstHeaderByte & 1) > 0;
        byte secondHeaderByte = channel.get();
        boolean startNodeNeedsLong = (secondHeaderByte & 0x80) > 0;
        boolean endNodeNeedsLong = (secondHeaderByte & 0x40) > 0;
        int indexNameId = LogCommandSerializationV3_0_10.getUnsignedShort(channel);
        int keyId = LogCommandSerializationV3_0_10.getUnsignedShort(channel);
        return new IndexCommandHeader(valueType, entityType, entityIdNeedsLong, indexNameId, startNodeNeedsLong, endNodeNeedsLong, keyId);
    }

    private static Object readIndexValue(byte valueType, ReadableChannel channel) throws IOException {
        switch (valueType) {
            case 0: {
                return null;
            }
            case 1: {
                return channel.getShort();
            }
            case 2: {
                return channel.getInt();
            }
            case 3: {
                return channel.getLong();
            }
            case 4: {
                return Float.valueOf(channel.getFloat());
            }
            case 5: {
                return channel.getDouble();
            }
            case 6: {
                return IoPrimitiveUtils.read3bLengthAndString((ReadableChannel)channel);
            }
        }
        throw new RuntimeException("Unknown value type " + valueType);
    }

    private static final class IndexCommandHeader {
        byte valueType;
        byte entityType;
        boolean entityIdNeedsLong;
        int indexNameId;
        boolean startNodeNeedsLong;
        boolean endNodeNeedsLong;
        int keyId;

        IndexCommandHeader(byte valueType, byte entityType, boolean entityIdNeedsLong, int indexNameId, boolean startNodeNeedsLong, boolean endNodeNeedsLong, int keyId) {
            this.valueType = valueType;
            this.entityType = entityType;
            this.entityIdNeedsLong = entityIdNeedsLong;
            this.indexNameId = indexNameId;
            this.startNodeNeedsLong = startNodeNeedsLong;
            this.endNodeNeedsLong = endNodeNeedsLong;
            this.keyId = keyId;
        }
    }
}

