/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.LogCommandSerializationV3_0_10;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_0;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_2;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_3_D3;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_4;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class RecordStorageCommandReaderFactory
implements CommandReaderFactory {
    public static final RecordStorageCommandReaderFactory INSTANCE = new RecordStorageCommandReaderFactory();
    public static final LogCommandSerialization LATEST_LOG_SERIALIZATION = INSTANCE.get(KernelVersion.LATEST);

    public LogCommandSerialization get(KernelVersion version) {
        switch (version) {
            case V2_3: {
                return LogCommandSerializationV3_0_10.INSTANCE;
            }
            case V4_0: {
                return LogCommandSerializationV4_0.INSTANCE;
            }
            case V4_2: {
                return LogCommandSerializationV4_2.INSTANCE;
            }
            case V4_3_D4: {
                return LogCommandSerializationV4_3_D3.INSTANCE;
            }
            case V4_4: {
                return LogCommandSerializationV4_4.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unsupported kernel version " + String.valueOf(version));
    }
}

