/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

class RecordStorageLocks
implements StorageLocks {
    private final ResourceLocker locker;

    RecordStorageLocks(ResourceLocker locker) {
        this.locker = locker;
    }

    public void acquireExclusiveNodeLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.NODE, ids);
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.locker.releaseExclusive((ResourceType)ResourceTypes.NODE, ids);
        this.locker.releaseExclusive((ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
    }

    public void acquireSharedNodeLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireShared(lockTracer, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.locker.acquireShared(lockTracer, (ResourceType)ResourceTypes.NODE, ids);
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.locker.releaseShared((ResourceType)ResourceTypes.NODE, ids);
        this.locker.releaseShared((ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
    }

    public void acquireExclusiveRelationshipLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP_DELETE, ids);
        this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP, ids);
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.locker.releaseExclusive((ResourceType)ResourceTypes.RELATIONSHIP, ids);
        this.locker.releaseExclusive((ResourceType)ResourceTypes.RELATIONSHIP_DELETE, ids);
    }

    public void acquireSharedRelationshipLock(LockTracer lockTracer, long ... ids) {
        this.locker.acquireShared(lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP_DELETE, ids);
        this.locker.acquireShared(lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP, ids);
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.locker.releaseShared((ResourceType)ResourceTypes.RELATIONSHIP, ids);
        this.locker.releaseShared((ResourceType)ResourceTypes.RELATIONSHIP_DELETE, ids);
    }

    public void acquireRelationshipCreationLock(ReadableTransactionState txState, LockTracer lockTracer, long sourceNode, long targetNode) {
        RecordStorageLocks.lockGroupAndDegrees(txState, this.locker, lockTracer, sourceNode, targetNode);
    }

    public void acquireRelationshipDeletionLock(ReadableTransactionState txState, LockTracer lockTracer, long sourceNode, long targetNode, long relationship) {
        RecordStorageLocks.lockGroupAndDegrees(txState, this.locker, lockTracer, sourceNode, targetNode);
        this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP_DELETE, new long[]{relationship});
    }

    public void acquireNodeDeletionLock(ReadableTransactionState txState, LockTracer lockTracer, long node) {
        if (!txState.nodeIsAddedInThisTx(node)) {
            this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, new long[]{node});
            this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.NODE, new long[]{node});
            this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.DEGREES, new long[]{node});
        }
    }

    public void acquireNodeLabelChangeLock(LockTracer lockTracer, long node, int labelId) {
        this.locker.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.DEGREES, new long[]{node});
    }

    private static void lockGroupAndDegrees(ReadableTransactionState txState, ResourceLocker locker, LockTracer lockTracer, long sourceNode, long targetNode) {
        RecordStorageLocks.lockGroupAndDegrees(txState, locker, lockTracer, Math.min(sourceNode, targetNode));
        if (sourceNode != targetNode) {
            RecordStorageLocks.lockGroupAndDegrees(txState, locker, lockTracer, Math.max(sourceNode, targetNode));
        }
    }

    private static void lockGroupAndDegrees(ReadableTransactionState txState, ResourceLocker locker, LockTracer lockTracer, long node) {
        if (!txState.nodeIsAddedInThisTx(node)) {
            locker.acquireShared(lockTracer, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, new long[]{node});
            locker.acquireShared(lockTracer, (ResourceType)ResourceTypes.DEGREES, new long[]{node});
        }
    }
}

