/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.legacy;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.internal.recordstorage.legacy.IndexCommand;
import org.neo4j.io.fs.IoPrimitiveUtils;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.Mask;
import org.neo4j.util.VisibleForTesting;

public class IndexDefineCommand
extends Command {
    static final int HIGHEST_POSSIBLE_ID = 65534;
    private final AtomicInteger nextIndexNameId = new AtomicInteger();
    private final AtomicInteger nextKeyId = new AtomicInteger();
    private MutableObjectIntMap<String> indexNameIdRange = new ObjectIntHashMap();
    private MutableObjectIntMap<String> keyIdRange = new ObjectIntHashMap();
    private MutableIntObjectMap<String> idToIndexName = new IntObjectHashMap();
    private MutableIntObjectMap<String> idToKey = new IntObjectHashMap();

    public IndexDefineCommand() {
        super(null);
    }

    public void init(MutableObjectIntMap<String> indexNames, MutableObjectIntMap<String> keys) {
        this.indexNameIdRange = Objects.requireNonNull(indexNames, "indexNames");
        this.keyIdRange = Objects.requireNonNull(keys, "keys");
        this.idToIndexName = indexNames.flipUniqueValues();
        this.idToKey = keys.flipUniqueValues();
    }

    private static String getFromMap(IntObjectMap<String> map, int id) {
        if (id == -1) {
            return null;
        }
        String result = (String)map.get(id);
        if (result == null) {
            throw new IllegalArgumentException(String.valueOf(id));
        }
        return result;
    }

    public String getKey(int id) {
        return IndexDefineCommand.getFromMap(this.idToKey, id);
    }

    public int getOrAssignIndexNameId(String indexName) {
        return IndexDefineCommand.getOrAssignId(this.indexNameIdRange, this.idToIndexName, this.nextIndexNameId, indexName);
    }

    public int getOrAssignKeyId(String key) {
        return IndexDefineCommand.getOrAssignId(this.keyIdRange, this.idToKey, this.nextKeyId, key);
    }

    private static int getOrAssignId(MutableObjectIntMap<String> stringToId, MutableIntObjectMap<String> idToString, AtomicInteger nextId, String string) {
        if (string == null) {
            return -1;
        }
        if (stringToId.containsKey((Object)string)) {
            return stringToId.get((Object)string);
        }
        int id = nextId.incrementAndGet();
        if (id > 65534 || stringToId.size() >= 65534) {
            throw new IllegalStateException(String.format("Modifying more than %d indexes or keys in a single transaction is not supported", 65535));
        }
        stringToId.put((Object)string, id);
        idToString.put(id, (Object)string);
        return id;
    }

    @Override
    public KernelVersion version() {
        return KernelVersion.V2_3;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexDefineCommand that = (IndexDefineCommand)o;
        return this.nextIndexNameId.get() == that.nextIndexNameId.get() && this.nextKeyId.get() == that.nextKeyId.get() && Objects.equals(this.indexNameIdRange, that.indexNameIdRange) && Objects.equals(this.keyIdRange, that.keyIdRange) && Objects.equals(this.idToIndexName, that.idToIndexName) && Objects.equals(this.idToKey, that.idToKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextIndexNameId.get(), this.nextKeyId.get(), this.indexNameIdRange, this.keyIdRange, this.idToIndexName, this.idToKey);
    }

    @Override
    public boolean handle(CommandVisitor visitor) throws IOException {
        throw new UnsupportedOperationException("Legacy command can't be applied.");
    }

    @VisibleForTesting
    ObjectIntMap<String> getIndexNameIdRange() {
        return this.indexNameIdRange;
    }

    @VisibleForTesting
    ObjectIntMap<String> getKeyIdRange() {
        return this.keyIdRange;
    }

    @Override
    public String toString(Mask mask) {
        return this.getClass().getSimpleName() + "[names:" + String.valueOf(this.indexNameIdRange) + ", keys:" + String.valueOf(this.keyIdRange) + "]";
    }

    public void serialize(WritableChannel channel) throws IOException {
        channel.put((byte)10);
        byte zero = 0;
        IndexCommand.writeIndexCommandHeader(channel, zero, zero, zero, zero, zero, zero, zero);
        try {
            IndexDefineCommand.writeMap(channel, this.indexNameIdRange);
            IndexDefineCommand.writeMap(channel, this.keyIdRange);
        }
        catch (UncheckedIOException e) {
            throw new IOException(e);
        }
    }

    private static void writeMap(WritableChannel channel, ObjectIntMap<String> map) throws IOException {
        assert (map.size() <= 65534) : "Can not write map with size larger than 2 bytes. Actual size " + map.size();
        channel.putShort((short)map.size());
        map.forEachKeyValue((ObjectIntProcedure & Serializable)(key, id) -> {
            assert (id <= 65534) : "Can not write id larger than 2 bytes. Actual value " + id;
            try {
                IoPrimitiveUtils.write2bLengthAndString((WritableChannel)channel, (String)key);
                channel.putShort((short)id);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

