/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class StandardDynamicRecordAllocator
implements DynamicRecordAllocator {
    protected final IdSequence idGenerator;
    private final int dataSize;

    public StandardDynamicRecordAllocator(IdSequence idGenerator, int dataSize) {
        this.idGenerator = idGenerator;
        this.dataSize = dataSize;
    }

    @Override
    public int getRecordDataSize() {
        return this.dataSize;
    }

    @Override
    public DynamicRecord nextRecord(CursorContext cursorContext) {
        return StandardDynamicRecordAllocator.allocateRecord(this.idGenerator.nextId(cursorContext));
    }

    public static DynamicRecord allocateRecord(long id) {
        DynamicRecord record = new DynamicRecord(id);
        record.setCreated();
        record.setInUse(true);
        return record;
    }
}

