/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Objects;
import org.neo4j.storageengine.api.Mask;

public abstract class AbstractBaseRecord {
    public static final int NO_ID = -1;
    private long id;
    private long secondaryUnitId;
    private boolean requiresSecondaryUnit;
    private boolean inUse;
    private boolean created;
    private boolean createdSecondaryUnit;
    private boolean useFixedReferences;

    protected AbstractBaseRecord(long id) {
        this.id = id;
        this.clear();
    }

    public AbstractBaseRecord(AbstractBaseRecord other) {
        this.id = other.id;
        this.secondaryUnitId = other.secondaryUnitId;
        this.requiresSecondaryUnit = other.requiresSecondaryUnit;
        this.inUse = other.inUse;
        this.created = other.created;
        this.createdSecondaryUnit = other.createdSecondaryUnit;
        this.useFixedReferences = other.useFixedReferences;
    }

    protected AbstractBaseRecord initialize(boolean inUse) {
        this.inUse = inUse;
        this.created = false;
        this.secondaryUnitId = -1L;
        this.requiresSecondaryUnit = false;
        this.useFixedReferences = false;
        return this;
    }

    public void clear() {
        this.inUse = false;
        this.created = false;
        this.secondaryUnitId = -1L;
        this.requiresSecondaryUnit = false;
        this.createdSecondaryUnit = false;
        this.useFixedReferences = false;
    }

    public AbstractBaseRecord copy() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not copyable.");
    }

    public long getId() {
        return this.id;
    }

    public int getIntId() {
        return Math.toIntExact(this.id);
    }

    public final void setId(long id) {
        this.id = id;
    }

    public void setSecondaryUnitIdOnLoad(long id, boolean requiresSecondaryUnit) {
        assert (!requiresSecondaryUnit || id != -1L) : "Secondary unit must either not be required or have an ID";
        this.secondaryUnitId = id;
        this.requiresSecondaryUnit = requiresSecondaryUnit;
    }

    public void setSecondaryUnitIdOnCreate(long id) {
        assert (id != -1L) : "Secondary unit cannot be set as created with NO_ID";
        this.secondaryUnitId = id;
        this.createdSecondaryUnit = true;
        this.requiresSecondaryUnit = true;
    }

    public boolean hasSecondaryUnitId() {
        return this.secondaryUnitId != -1L;
    }

    public long getSecondaryUnitId() {
        return this.secondaryUnitId;
    }

    public void setRequiresSecondaryUnit(boolean requires) {
        this.requiresSecondaryUnit = requires;
    }

    public boolean requiresSecondaryUnit() {
        return this.requiresSecondaryUnit;
    }

    public boolean isSecondaryUnitCreated() {
        return this.createdSecondaryUnit;
    }

    public final boolean inUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public final void setCreated() {
        this.created = true;
    }

    public final boolean isCreated() {
        return this.created;
    }

    public boolean isUseFixedReferences() {
        return this.useFixedReferences;
    }

    public void setUseFixedReferences(boolean useFixedReferences) {
        this.useFixedReferences = useFixedReferences;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inUse, this.requiresSecondaryUnit, this.useFixedReferences);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBaseRecord other = (AbstractBaseRecord)obj;
        return this.id == other.id && this.inUse == other.inUse && this.requiresSecondaryUnit == other.requiresSecondaryUnit && this.useFixedReferences == other.useFixedReferences;
    }

    protected String secondaryUnitToString() {
        if (!this.requiresSecondaryUnit() && !this.hasSecondaryUnitId()) {
            return "";
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.requiresSecondaryUnit() ? (this.createdSecondaryUnit ? "+" : "") : "-";
        objectArray[1] = this.getSecondaryUnitId();
        return String.format(",%ssecondaryUnitId=%d", objectArray);
    }

    public final String toString() {
        return this.toString(Mask.NO);
    }

    public abstract String toString(Mask var1);
}

