/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.util.Iterator;
import java.util.function.ToLongFunction;
import org.apache.lucene.document.Document;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

public class LuceneAllEntriesIndexAccessorReader
implements BoundedIterable<Long> {
    private final BoundedIterable<Document> documents;
    private final ToLongFunction<Document> entityIdReader;
    private final long fromIdInclusive;
    private final long toIdExclusive;

    public LuceneAllEntriesIndexAccessorReader(BoundedIterable<Document> documents, ToLongFunction<Document> entityIdReader, long fromIdInclusive, long toIdExclusive) {
        this.documents = documents;
        this.entityIdReader = entityIdReader;
        this.fromIdInclusive = fromIdInclusive;
        this.toIdExclusive = toIdExclusive;
    }

    public long maxCount() {
        return this.documents.maxCount();
    }

    public Iterator<Long> iterator() {
        final Iterator iterator = this.documents.iterator();
        return new PrefetchingIterator<Long>(){

            protected Long fetchNextOrNull() {
                long id;
                do {
                    if (iterator.hasNext()) continue;
                    return null;
                } while ((id = LuceneAllEntriesIndexAccessorReader.this.entityIdReader.applyAsLong((Document)iterator.next())) < LuceneAllEntriesIndexAccessorReader.this.fromIdInclusive || id >= LuceneAllEntriesIndexAccessorReader.this.toIdExclusive);
                return id;
            }
        };
    }

    public void close() throws Exception {
        this.documents.close();
    }
}

