/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checker.RecordStorageConsistencyChecker;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsStore;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

public class FullCheck {
    private static final String INDEX_STRUCTURE_CHECKER_TAG = "indexStructureChecker";
    private final Config config;
    private final DebugContext debugContext;
    private final NodeBasedMemoryLimiter.Factory memoryLimit;
    private final ProgressMonitorFactory progressFactory;
    private final IndexSamplingConfig samplingConfig;
    private final int threads;
    private final ConsistencyFlags flags;

    public FullCheck(ProgressMonitorFactory progressFactory, int threads, ConsistencyFlags consistencyFlags, Config config, DebugContext debugContext, NodeBasedMemoryLimiter.Factory memoryLimit) {
        this.threads = threads;
        this.progressFactory = progressFactory;
        this.flags = consistencyFlags;
        this.samplingConfig = new IndexSamplingConfig(config);
        this.config = config;
        this.debugContext = debugContext;
        this.memoryLimit = memoryLimit;
    }

    public ConsistencySummaryStatistics execute(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> countsSupplier, ThrowingSupplier<RelationshipGroupDegreesStore, IOException> groupDegreesStoreSupplier, IndexAccessors.IndexAccessorLookup indexAccessorLookup, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, Log log) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(log, FullCheck.moreDescriptiveRecordToStrings(stores)), summary);
        CountsStore countsStore = this.getCountsStore(countsSupplier, log, summary);
        RelationshipGroupDegreesStore groupDegreesStore = this.getGroupDegreesStore(groupDegreesStoreSupplier, log, summary);
        this.execute(pageCache, stores, report, countsStore, groupDegreesStore, indexAccessorLookup, pageCacheTracer, memoryTracker);
        if (!summary.isConsistent()) {
            log.warn("Inconsistencies found: " + String.valueOf(summary));
        }
        return summary;
    }

    private static Function<AbstractBaseRecord, String> moreDescriptiveRecordToStrings(DirectStoreAccess stores) {
        return record -> {
            Object result = record.toString();
            if (record instanceof SchemaRecord) {
                try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores.nativeStores(), CursorContext.NULL);){
                    SchemaRule schemaRule = SchemaStore.readSchemaRule((SchemaRecord)((SchemaRecord)record), (PropertyStore)stores.nativeStores().getPropertyStore(), (TokenHolders)stores.tokenHolders(), (StoreCursors)storeCursors);
                    result = (String)result + " (" + schemaRule.userDescription((TokenNameLookup)stores.tokenHolders()) + ")";
                }
                catch (Exception e) {
                    result = (String)result + " (schema user description not available due to: " + String.valueOf(e) + ")";
                }
            }
            return result;
        };
    }

    private CountsStore getCountsStore(ThrowingSupplier<CountsStore, IOException> countsSupplier, Log log, ConsistencySummaryStatistics summary) {
        CountsStore countsStore = CountsStore.NULL_INSTANCE;
        if (this.flags.isCheckGraph() || this.flags.isCheckIndexStructure()) {
            try {
                countsStore = (CountsStore)countsSupplier.get();
            }
            catch (Exception e) {
                log.error("Counts store is missing, broken or of an older format and will not be consistency checked", (Throwable)e);
                summary.genericError("Counts store is missing, broken or of an older format");
            }
        }
        return countsStore;
    }

    private RelationshipGroupDegreesStore getGroupDegreesStore(ThrowingSupplier<RelationshipGroupDegreesStore, IOException> groupDegreesStoreSupplier, Log log, ConsistencySummaryStatistics summary) {
        RelationshipGroupDegreesStore store = null;
        if (this.flags.isCheckIndexStructure()) {
            try {
                store = (RelationshipGroupDegreesStore)groupDegreesStoreSupplier.get();
            }
            catch (Exception e) {
                log.error("Relationship group degrees store is missing, broken or of an older format and will not be consistency checked", (Throwable)e);
                summary.genericError("Relationship group degrees store is missing, broken or of an older format");
            }
        }
        return store;
    }

    void execute(PageCache pageCache, DirectStoreAccess directStoreAccess, InconsistencyReport report, CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore, IndexAccessors.IndexAccessorLookup indexAccessorLookup, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        try (IndexAccessors indexes = new IndexAccessors(directStoreAccess.indexes(), directStoreAccess.nativeStores(), this.samplingConfig, indexAccessorLookup, pageCacheTracer, directStoreAccess.tokenHolders().lookupWithIds(), (KernelVersionRepository)directStoreAccess.nativeStores().getMetaDataStore());){
            if (this.flags.isCheckIndexStructure()) {
                FullCheck.consistencyCheckIndexStructure(directStoreAccess.indexStatisticsStore(), countsStore, groupDegreesStore, indexes, FullCheck.allIdGenerators(directStoreAccess), report, this.progressFactory, pageCacheTracer);
            }
            try (RecordStorageConsistencyChecker checker = new RecordStorageConsistencyChecker(pageCache, directStoreAccess.nativeStores(), countsStore, indexes, report, this.progressFactory, this.config, this.threads, this.debugContext, this.flags, this.memoryLimit, pageCacheTracer, memoryTracker);){
                checker.check();
            }
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    private static List<IdGenerator> allIdGenerators(DirectStoreAccess directStoreAccess) {
        ArrayList<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
        directStoreAccess.idGeneratorFactory().visit(idGenerators::add);
        return idGenerators;
    }

    private static void consistencyCheckIndexStructure(IndexStatisticsStore indexStatisticsStore, CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore, IndexAccessors indexes, List<IdGenerator> idGenerators, InconsistencyReport report, ProgressMonitorFactory progressMonitorFactory, PageCacheTracer pageCacheTracer) {
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(INDEX_STRUCTURE_CHECKER_TAG));){
            long schemaIndexCount = Iterables.count(indexes.onlineRules());
            long additionalCount = 2L;
            if (FullCheck.hasNodeLabelIndex(indexes)) {
                ++additionalCount;
            }
            if (FullCheck.hasRelationshipTypeIndex(indexes)) {
                ++additionalCount;
            }
            if (FullCheck.hasGroupDegreesStore(groupDegreesStore)) {
                ++additionalCount;
            }
            long idGeneratorsCount = idGenerators.size();
            long totalCount = schemaIndexCount + additionalCount + idGeneratorsCount;
            ProgressListener listener = progressMonitorFactory.singlePart("Index structure consistency check", totalCount);
            listener.started();
            FullCheck.consistencyCheckNonSchemaIndexes(report, listener, indexStatisticsStore, countsStore, groupDegreesStore, idGenerators, cursorContext);
            FullCheck.consistencyCheckSchemaIndexes(indexes, report, listener, cursorContext);
            listener.done();
        }
    }

    private static void consistencyCheckNonSchemaIndexes(InconsistencyReport report, ProgressListener listener, IndexStatisticsStore indexStatisticsStore, CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore, List<IdGenerator> idGenerators, CursorContext cursorContext) {
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)indexStatisticsStore, RecordType.INDEX_STATISTICS, cursorContext);
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)countsStore, RecordType.COUNTS, cursorContext);
        if (FullCheck.hasGroupDegreesStore(groupDegreesStore)) {
            FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)groupDegreesStore, RecordType.RELATIONSHIP_GROUP, cursorContext);
        }
        for (IdGenerator idGenerator : idGenerators) {
            FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)idGenerator, RecordType.ID_STORE, cursorContext);
        }
    }

    private static void consistencyCheckSingleCheckable(InconsistencyReport report, ProgressListener listener, ConsistencyCheckable checkable, RecordType recordType, CursorContext cursorContext) {
        ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, recordType);
        ReporterFactory proxyFactory = new ReporterFactory((InvocationHandler)handler);
        checkable.consistencyCheck(proxyFactory, cursorContext);
        handler.updateSummary();
        listener.add(1L);
    }

    private static void consistencyCheckSchemaIndexes(IndexAccessors indexes, InconsistencyReport report, ProgressListener listener, CursorContext cursorContext) {
        if (FullCheck.hasNodeLabelIndex(indexes)) {
            FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)indexes.nodeLabelIndex(), RecordType.LABEL_SCAN_DOCUMENT, cursorContext);
        }
        if (FullCheck.hasRelationshipTypeIndex(indexes)) {
            FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)indexes.relationshipTypeIndex(), RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, cursorContext);
        }
        ArrayList<IndexDescriptor> rulesToRemove = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor onlineRule : indexes.onlineRules()) {
            ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, RecordType.INDEX);
            ReporterFactory reporterFactory = new ReporterFactory((InvocationHandler)handler);
            IndexAccessor accessor = indexes.accessorFor(onlineRule);
            if (!accessor.consistencyCheck(reporterFactory, cursorContext)) {
                rulesToRemove.add(onlineRule);
            }
            handler.updateSummary();
            listener.add(1L);
        }
        for (IndexDescriptor toRemove : rulesToRemove) {
            indexes.remove(toRemove);
        }
    }

    private static boolean hasGroupDegreesStore(RelationshipGroupDegreesStore groupDegreesStore) {
        return groupDegreesStore != null;
    }

    private static boolean hasNodeLabelIndex(IndexAccessors indexes) {
        return indexes.nodeLabelIndex() != null;
    }

    private static boolean hasRelationshipTypeIndex(IndexAccessors indexes) {
        return indexes.relationshipTypeIndex() != null;
    }
}

