/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.common;

import com.neo4j.fleetmanagement.common.ExceptionWork;
import com.neo4j.fleetmanagement.common.TransactionWork;
import com.neo4j.fleetmanagement.common.VoidTransactionWork;
import com.neo4j.fleetmanagement.utils.Logger;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class TransactionUtil {
    private static final ClientConnectionInfo EFM_CONNECTION = new ClientConnectionInfo(){

        public String asConnectionDetails() {
            return "fleet-management-session\t";
        }

        public String protocol() {
            return "fleet-management-embedded";
        }

        public String connectionId() {
            return null;
        }
    };

    private static Log getLog() {
        return Logger.getNeo4jLogger();
    }

    public static <T> T withTransaction(DatabaseManagementService service, String databaseName, TransactionWork<T> work) {
        GraphDatabaseAPI db;
        try {
            db = (GraphDatabaseAPI)service.database(databaseName);
        }
        catch (DatabaseNotFoundException e2) {
            TransactionUtil.getLog().error("Fleet management plugin encountered an error: Database not found: " + databaseName, (Throwable)e2);
            return null;
        }
        return (T)TransactionUtil.withTransactionAndErrorHandling(db, work, e -> {
            TransactionUtil.getLog().error("Fleet management plugin encountered an error: " + e.getMessage(), (Throwable)e);
            return null;
        });
    }

    public static <T> T withSystemTransaction(DatabaseManagementService service, TransactionWork<T> work) {
        return (T)TransactionUtil.withSystemTransactionAndErrorHandling(service, work, e -> {
            TransactionUtil.getLog().error("Fleet management plugin encountered an error: " + e.getMessage(), (Throwable)e);
            return null;
        });
    }

    public static void withSystemTransaction(DatabaseManagementService service, VoidTransactionWork work) {
        TransactionUtil.withSystemTransactionAndErrorHandling(service, tx -> {
            work.execute(tx);
            return null;
        }, e -> {
            TransactionUtil.getLog().error("Fleet management plugin encountered an error: " + e.getMessage(), (Throwable)e);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withTransactionAndErrorHandling(GraphDatabaseAPI api, TransactionWork<T> work, ExceptionWork<T> errorHandler) {
        try (InternalTransaction tx = api.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.fullAccess((ClientConnectionInfo)EFM_CONNECTION), EFM_CONNECTION);){
            T t = work.execute((Transaction)tx);
            return t;
        }
        catch (Exception e) {
            return errorHandler.execute(e);
        }
    }

    public static <T> T withSystemTransactionAndErrorHandling(DatabaseManagementService service, TransactionWork<T> work, ExceptionWork<T> errorHandler) {
        GraphDatabaseAPI systemDb = (GraphDatabaseAPI)service.database("system");
        return TransactionUtil.withTransactionAndErrorHandling(systemDb, work, errorHandler);
    }
}

