/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.neo4j.fleetmanagement.communication.BaseService;
import com.neo4j.fleetmanagement.communication.Helpers;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import java.io.IOException;

public abstract class AbstractReportingService
extends BaseService {
    protected final Upstream upstream;

    protected AbstractReportingService(ITransactor transactor, Upstream upstream) {
        super(transactor);
        this.upstream = upstream;
    }

    public abstract void report();

    protected void transmitReport(Object msg, Upstream.Endpoint endpoint) {
        this.transmitReportWithResponse(msg, endpoint);
    }

    protected Response transmitReportWithResponse(Object msg, Upstream.Endpoint endpoint) {
        String messageName = msg.getClass().getSimpleName();
        try {
            byte[] responseBody;
            String payload = this.objectMapper.writeValueAsString(msg);
            this.pluginLog.debug("Fleet management plugin reporting " + messageName);
            this.pluginLog.payload("Fleet management plugin reporting " + messageName + ": " + payload);
            Upstream.UpstreamPostRequest upstreamPostRequest = this.upstream.postTo(endpoint);
            int responseCode = upstreamPostRequest.transmit(payload.getBytes());
            try {
                responseBody = upstreamPostRequest.getResponseBody();
            }
            catch (IOException e) {
                String errorMsg = "Fleet management plugin failed to parse error response - IOException: " + e.getMessage();
                this.userLog.error(errorMsg);
                this.state.setDisconnected(errorMsg);
                return null;
            }
            if (!Helpers.responseOk(responseCode)) {
                this.handleErrorResponse("Fleet management plugin failed to report", responseCode, responseBody);
                return null;
            }
            if (responseBody != null) {
                this.pluginLog.payload("Fleet management plugin reporting " + messageName + " received response: " + new String(responseBody));
            }
            return new Response(responseCode, responseBody);
        }
        catch (IOException e) {
            String errorMsg = "Fleet management plugin failed to report " + messageName + " - " + String.valueOf(e);
            this.state.setDisconnected(errorMsg);
            this.userLog.error(errorMsg);
            throw new RuntimeException(e);
        }
    }

    protected static class Response {
        protected int responseCode;
        protected byte[] responseBody;

        protected Response(int responseCode, byte[] responseBody) {
            this.responseCode = responseCode;
            this.responseBody = responseBody;
        }
    }
}

