/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.metrics;

import com.neo4j.fleetmanagement.bootstrap.PluginBuildProfile;
import com.neo4j.fleetmanagement.communication.model.DataPoint;
import com.neo4j.fleetmanagement.configuration.Configuration;
import com.neo4j.fleetmanagement.metrics.ICollector;
import com.neo4j.fleetmanagement.metrics.MetricContext;
import com.neo4j.fleetmanagement.metrics.model.MetricsDefinition;
import com.neo4j.fleetmanagement.utils.Logger;
import com.neo4j.fleetmanagement.utils.PatternCompiler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.config.Setting;

public class Neo4jMetricsCollector
implements ICollector,
PropertyChangeListener {
    private static final String[] percentiles = new String[]{"99thPercentile", "75thPercentile", "50thPercentile"};
    private static final String[] quantileLabels = new String[]{"0.99", "0.75", "0.50"};
    private Map<Pattern, MetricsDefinition> jmxMetricSpecifications;
    private final Configuration configuration = Configuration.getInstance();
    private final String query;

    public Neo4jMetricsCollector(Config config, PluginBuildProfile pluginBuildProfile) {
        this.configuration.addPropertyChangeListener(this);
        this.jmxMetricSpecifications = new HashMap<Pattern, MetricsDefinition>();
        this.updateJmxMetricSpecifications(this.configuration.getMetrics());
        this.query = String.format("%s.metrics:*", Neo4jMetricsCollector.getMetricsPrefix(config, pluginBuildProfile));
    }

    private static String getMetricsPrefixConfiguration(PluginBuildProfile pluginBuildProfile) {
        return pluginBuildProfile == PluginBuildProfile.v4 ? "metrics.prefix" : "server.metrics.prefix";
    }

    private static String getMetricsPrefix(Config config, PluginBuildProfile pluginBuildProfile) {
        String metricsPrefixConfig = Neo4jMetricsCollector.getMetricsPrefixConfiguration(pluginBuildProfile);
        Map declaredSettings = config.getDeclaredSettings();
        if (declaredSettings.containsKey(metricsPrefixConfig)) {
            return config.get((Setting)declaredSettings.get(metricsPrefixConfig)).toString();
        }
        return "neo4j";
    }

    @Override
    public void collect(Map<String, List<DataPoint>> data) {
        Logger.getPluginLogger().debug(String.format("will use query %s to collect metrics=", this.query));
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            for (ObjectName name : jmxServer.queryNames(new ObjectName(this.query), null)) {
                MetricContext metricContext = this.getMetricContext(name);
                if (metricContext == null) continue;
                this.processMetric(jmxServer, metricContext, data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processMetric(MBeanServer jmxServer, MetricContext metricContext, Map<String, List<DataPoint>> data) throws Exception {
        switch (metricContext.getMetricDefinition().getJmxMetricSpecification().metricType) {
            case GAUGE: {
                Object value = jmxServer.getAttribute(metricContext.getName(), "Value");
                data.computeIfAbsent(metricContext.getMetricDefinition().getName(), k -> new ArrayList()).add(new DataPoint(metricContext.getTags(), ((Number)value).doubleValue()));
                break;
            }
            case HISTOGRAM: {
                for (int i = 0; i < percentiles.length; ++i) {
                    String percentileAttr = percentiles[i];
                    String percentileLabel = quantileLabels[i];
                    Object percentileValue = jmxServer.getAttribute(metricContext.getName(), percentileAttr);
                    HashMap<String, String> tagsWithPercentile = new HashMap<String, String>(metricContext.getTags());
                    tagsWithPercentile.put("quantile", percentileLabel);
                    data.computeIfAbsent(metricContext.getMetricDefinition().getName(), k -> new ArrayList()).add(new DataPoint(tagsWithPercentile, ((Number)percentileValue).doubleValue()));
                }
                break;
            }
            case COUNTER: {
                Object count = jmxServer.getAttribute(metricContext.getName(), "Count");
                data.computeIfAbsent(metricContext.getMetricDefinition().getName(), k -> new ArrayList()).add(new DataPoint(metricContext.getTags(), ((Number)count).doubleValue()));
            }
        }
    }

    private MetricContext getMetricContext(ObjectName name) {
        String strippedName = name.getCanonicalName().replace("neo4j.metrics:name=", "");
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry<Pattern, MetricsDefinition> entry : this.jmxMetricSpecifications.entrySet()) {
            Matcher matcher = entry.getKey().matcher(strippedName);
            if (!matcher.matches()) continue;
            MetricsDefinition metricDef = entry.getValue();
            if (metricDef.getTags() == null) {
                return new MetricContext(metricDef, tags, name);
            }
            for (String tag : metricDef.getTags()) {
                try {
                    if (matcher.group(tag) == null) continue;
                    tags.put(tag, matcher.group(tag));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return new MetricContext(metricDef, tags, name);
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("metrics")) {
            this.updateJmxMetricSpecifications(this.configuration.getMetrics());
        }
    }

    private void updateJmxMetricSpecifications(List<MetricsDefinition> metricsSpec) {
        if (metricsSpec == null) {
            return;
        }
        this.jmxMetricSpecifications = new HashMap<Pattern, MetricsDefinition>();
        for (MetricsDefinition def : metricsSpec) {
            String metricName = def.getMetricName();
            this.jmxMetricSpecifications.put(PatternCompiler.constructPattern(metricName), def);
        }
    }
}

