/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.procedures;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.neo4j.fleetmanagement.common.ValuesDocumentation;
import com.neo4j.fleetmanagement.communication.model.ConnectMessage;
import com.neo4j.fleetmanagement.communication.model.MetricsMessage;
import com.neo4j.fleetmanagement.communication.model.Neo4jConfigMessage;
import com.neo4j.fleetmanagement.communication.model.PingMessage;
import com.neo4j.fleetmanagement.communication.model.ReportingMessage;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;

public class Documentation {
    @Procedure(name="fleetManagement.reportedData", mode=Mode.READ)
    @SystemProcedure
    @Description(value="Generate documentation for the data structures used in fleet management messages")
    public Stream<DocumentationResult> generateDocumentation() throws Exception {
        ArrayList<DocumentationResult> results = new ArrayList<DocumentationResult>();
        this.documentClass(ConnectMessage.class, "ConnectMessage", "", results);
        this.documentClass(MetricsMessage.class, "MetricsMessage", "", results);
        this.documentClass(Neo4jConfigMessage.class, "Neo4jConfigMessage", "", results);
        this.documentClass(ReportingMessage.class, "ReportingMessage", "", results);
        this.documentClass(PingMessage.class, "PingMessage", "", results);
        return results.stream();
    }

    private void documentClass(Class<?> clazz, String messageType, String prefix, List<DocumentationResult> results) throws Exception {
        JsonClassDescription classDescription = clazz.getAnnotation(JsonClassDescription.class);
        if (classDescription != null) {
            results.add(new DocumentationResult(messageType, prefix, classDescription.value(), Documentation.getTypeString(clazz), null));
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.documentField(messageType, prefix, results, field);
        }
    }

    private void documentField(String messageType, String prefix, List<DocumentationResult> results, Field field) throws Exception {
        Class<Object> fieldType;
        String fieldPath = Documentation.getFieldPath(prefix, field);
        JsonPropertyDescription fieldDescription = field.getAnnotation(JsonPropertyDescription.class);
        if (fieldDescription != null) {
            results.add(new DocumentationResult(messageType, fieldPath, fieldDescription.value(), Documentation.getTypeString(field.getGenericType()), Documentation.getValues(field)));
        }
        if ((fieldType = field.getType()).isAssignableFrom(List.class)) {
            Type firstTypeArgument = Documentation.getGenericArgument(field.getGenericType(), 0);
            this.documentList(messageType, results, firstTypeArgument, fieldPath);
        } else if (fieldType.isAssignableFrom(Map.class)) {
            this.documentMap(messageType, results, Documentation.getGenericArgument(field.getGenericType(), 1), fieldPath);
        } else if (Documentation.isRelevant(fieldType)) {
            this.documentClass(fieldType, messageType, fieldPath, results);
        }
    }

    private static String getFieldPath(String prefix, Field field) {
        String fieldName;
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        String string = fieldName = jsonProperty == null ? field.getName() : jsonProperty.value();
        if (prefix.isEmpty()) {
            return fieldName;
        }
        return String.format("%s.%s", prefix, fieldName);
    }

    private static List<String> getValues(Field field) throws Exception {
        ValuesDocumentation valuesDocumentation = field.getAnnotation(ValuesDocumentation.class);
        if (valuesDocumentation != null) {
            return valuesDocumentation.valueSupplier().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get();
        }
        return null;
    }

    private static Type getGenericArgument(Type type, int index) {
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && index < (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()).length) {
            return actualTypeArguments[index];
        }
        throw new IllegalArgumentException(String.format("Cannot get type argument at index %d from %s", index, type));
    }

    private static boolean isRelevant(Class<?> clazz) {
        return !clazz.isEnum() && clazz.getPackageName().contains("fleetmanagement");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void documentMap(String messageType, List<DocumentationResult> results, Type valueType, String fieldPath) throws Exception {
        if (valueType instanceof ParameterizedType) {
            Type rawValueType = ((ParameterizedType)valueType).getRawType();
            String newPath = String.format("%s<>", fieldPath);
            if (rawValueType == List.class) {
                this.documentList(messageType, results, Documentation.getGenericArgument(valueType, 0), newPath);
                return;
            } else {
                if (rawValueType != Map.class) throw new IllegalArgumentException(String.format("Unsupported Map value type: %s", valueType));
                this.documentMap(messageType, results, Documentation.getGenericArgument(valueType, 1), newPath);
            }
            return;
        } else {
            if (!Documentation.isRelevant(Documentation.getClazz(valueType))) return;
            this.documentClass(Documentation.getClazz(valueType), messageType, fieldPath + Documentation.getTypeString(valueType), results);
        }
    }

    private void documentList(String messageType, List<DocumentationResult> results, Type elementType, String fieldPath) throws Exception {
        this.documentClass(Documentation.getClazz(elementType), messageType, String.format("%s[]", fieldPath), results);
    }

    private static Class<?> getClazz(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
            return Documentation.getClazz(rawType);
        }
        return (Class)type;
    }

    private static String getTypeString(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawValueType = ((ParameterizedType)type).getRawType();
            if (List.class.isAssignableFrom((Class)rawValueType)) {
                return String.format("List<%s>", Documentation.getTypeString(Documentation.getGenericArgument(type, 0)));
            }
            if (Map.class.isAssignableFrom((Class)rawValueType)) {
                return String.format("Map<%s, %s>", Documentation.getTypeString(Documentation.getGenericArgument(type, 0)), Documentation.getTypeString(Documentation.getGenericArgument(type, 1)));
            }
            throw new IllegalArgumentException(String.format("Unsupported type: %s", type));
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return String.format("%s[]", Documentation.getTypeString(clazz.getComponentType()));
        }
        if (clazz.isEnum()) {
            return "String";
        }
        return clazz.getSimpleName();
    }

    public static class DocumentationResult {
        public String messageType;
        public String fieldPath;
        public String description;
        public String fieldType;
        public List<String> values;

        public DocumentationResult(String messageType, String fieldPath, String description, String fieldType, List<String> values) {
            this.messageType = messageType;
            this.fieldPath = fieldPath;
            this.description = description;
            this.fieldType = fieldType;
            this.values = values;
        }

        public String toString() {
            return String.format("DocumentationResult{messageType='%s', fieldPath='%s', description='%s', fieldType='%s', values='%s'}", this.messageType, this.fieldPath, this.description, this.fieldType, this.values);
        }
    }
}

