/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions.editions;

import com.neo4j.fleetmanagement.common.TransactionUtil;
import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.transactions.AbstractTransactor;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.transactions.editions.Shared;
import com.neo4j.fleetmanagement.transactions.model.ResultMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.graphdb.Result;

public class v4_CommunityTransactor
extends AbstractTransactor
implements ITransactor {
    private final ServerIdentity serverIdentity;

    public v4_CommunityTransactor(ServerIdentity serverIdentity) {
        this.serverIdentity = serverIdentity;
    }

    @Override
    public Map<String, Server> getServers() {
        HashMap<String, Server> instanceMap = new HashMap<String, Server>();
        Server server = new Server();
        server.serverId = this.serverIdentity.serverId().uuid().toString();
        try {
            server.address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.log.error("Unable to resolve host address", (Throwable)e);
            throw new RuntimeException(e);
        }
        server.health = "Available";
        server.modeConstraint = "NONE";
        server.version = this.getVersionAndEdition().version;
        instanceMap.put(this.serverIdentity.serverId().uuid().toString(), server);
        return instanceMap;
    }

    @Override
    public Map<String, List<Database>> getDatabases() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            HashMap<String, List> databasesByInstance = new HashMap<String, List>();
            Result r = tx.execute("SHOW DATABASES YIELD name, role, serverID, aliases, access, databaseID, requestedStatus, currentStatus, error, default, home, lastCommittedTxn, replicationLag");
            tx.commit();
            while (r.hasNext()) {
                ResultMap instanceDatabases = new ResultMap(r.next());
                String serverId = instanceDatabases.get("serverID").toString();
                List dbArray = databasesByInstance.computeIfAbsent(serverId, k -> new ArrayList());
                Database oneDb = Shared.getDatabaseWithSharedProps(instanceDatabases);
                Shared.addV4SpecificProps(oneDb, instanceDatabases);
                dbArray.add(oneDb);
            }
            return databasesByInstance;
        });
    }

    @Override
    public Server.License getLicense() {
        Server.License license = new Server.License();
        license.type = Server.License.LicenseType.FREE;
        license.state = Server.License.LicenseState.VALID;
        return license;
    }

    @Override
    public void setToken(String token) {
        super.setToken(token);
    }

    @Override
    public void rotateToken() {
        super.rotateToken();
    }

    @Override
    public void deleteToken() {
        super.deleteToken();
    }
}

