/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions.model;

import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultMap
extends HashMap<String, Object> {
    public ResultMap(Map<String, Object> m) {
        this.putAll(m);
    }

    public String getString(String key, String fallback) {
        Object value = this.get(key);
        return value != null ? value.toString() : fallback;
    }

    public String getString(String key) throws IllegalArgumentException {
        Object value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        return value.toString();
    }

    public List<String> getStringList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            try {
                return (List)value;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Value for '" + key + "' cannot be converted to List<String>: " + String.valueOf(value), e);
            }
        }
        throw new IllegalArgumentException("Value for '" + key + "' cannot be converted to List<String>: " + value.getClass().getName());
    }

    public boolean getBoolean(String key) throws IllegalArgumentException {
        Object value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public long getLong(String key) throws IllegalArgumentException {
        Object value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value for '" + key + "' cannot be converted to long: " + String.valueOf(value));
        }
    }

    public Integer getInteger(String key) throws IllegalArgumentException {
        Object value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value for '" + key + "' cannot be converted to Integer: " + String.valueOf(value));
        }
    }

    public Integer getInteger(String key, Integer fallback) throws IllegalArgumentException {
        Object value = this.get(key);
        if (value == null) {
            return fallback;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value for '" + key + "' cannot be converted to Integer: " + String.valueOf(value));
        }
    }

    public ZonedDateTime getZonedDateTime(String key) throws IllegalArgumentException {
        Object value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        try {
            return ZonedDateTime.parse(value.toString());
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Value for '" + key + "' cannot be converted to ZonedDateTime: " + String.valueOf(value));
        }
    }
}

