/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions;

import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.topology.model.GraphCount;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.transactions.editions.v4_CommunityTransactor;
import com.neo4j.fleetmanagement.transactions.editions.v4_EnterpriseTransactor;
import com.neo4j.fleetmanagement.transactions.model.VersionAndEdition;
import java.util.List;
import java.util.Map;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.kernel.impl.factory.DbmsInfo;

public class v4_Transactor
implements ITransactor {
    private final ITransactor editionTransactor;

    public v4_Transactor() {
        this.editionTransactor = null;
    }

    public v4_Transactor(DbmsInfo dbmsInfo, ServerIdentity serverIdentity) {
        if (dbmsInfo == null) {
            throw new IllegalArgumentException("dbmsInfo cannot be null");
        }
        switch (dbmsInfo) {
            case ENTERPRISE: 
            case CORE: 
            case READ_REPLICA: {
                this.editionTransactor = new v4_EnterpriseTransactor();
                break;
            }
            case COMMUNITY: {
                this.editionTransactor = new v4_CommunityTransactor(serverIdentity);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported dbms edition: " + String.valueOf(dbmsInfo));
            }
        }
    }

    @Override
    public void init(DatabaseManagementService databaseManagementService) {
        this.editionTransactor.init(databaseManagementService);
    }

    @Override
    public boolean getTokenStatus() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getTokenStatus();
    }

    @Override
    public boolean getTokenRotationStatus() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getTokenRotationStatus();
    }

    @Override
    public String getToken() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getToken();
    }

    @Override
    public VersionAndEdition getVersionAndEdition() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getVersionAndEdition();
    }

    @Override
    public Map<String, Server> getServers() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getServers();
    }

    @Override
    public Map<String, List<Database>> getDatabases() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getDatabases();
    }

    @Override
    public Server.License getLicense() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getLicense();
    }

    @Override
    public Server.License getGdsLicense() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getGdsLicense();
    }

    @Override
    public Server.License getBloomLicense() {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getBloomLicense();
    }

    @Override
    public GraphCount getGraphCount(String databaseName) {
        assert (this.editionTransactor != null);
        return this.editionTransactor.getGraphCount(databaseName);
    }

    @Override
    public void setToken(String token) {
        assert (this.editionTransactor != null);
        this.editionTransactor.setToken(token);
    }

    @Override
    public void rotateToken() {
        assert (this.editionTransactor != null);
        this.editionTransactor.rotateToken();
    }

    @Override
    public void deleteToken() {
        assert (this.editionTransactor != null);
        this.editionTransactor.deleteToken();
    }
}

