/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.impl.StandardExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.NestingResourceIterator;
import org.neo4j.internal.helpers.collection.Pair;

public final class OrderedByTypeExpander
extends StandardExpander.RegularExpander {
    private final Collection<Pair<RelationshipType, Direction>> orderedTypes;

    public OrderedByTypeExpander() {
        this(Collections.emptyList());
    }

    private OrderedByTypeExpander(Collection<Pair<RelationshipType, Direction>> orderedTypes) {
        super(Collections.emptyMap());
        this.orderedTypes = orderedTypes;
    }

    @Override
    public StandardExpander add(RelationshipType type, Direction direction) {
        ArrayList<Pair<RelationshipType, Direction>> newTypes = new ArrayList<Pair<RelationshipType, Direction>>(this.orderedTypes);
        newTypes.add((Pair<RelationshipType, Direction>)Pair.of((Object)type, (Object)((Object)direction)));
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    public StandardExpander remove(RelationshipType type) {
        ArrayList<Pair<RelationshipType, Direction>> newTypes = new ArrayList<Pair<RelationshipType, Direction>>();
        for (Pair<RelationshipType, Direction> pair : this.orderedTypes) {
            if (type.name().equals(((RelationshipType)pair.first()).name())) continue;
            newTypes.add(pair);
        }
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    void buildString(StringBuilder result) {
        result.append(this.orderedTypes);
    }

    @Override
    public StandardExpander reverse() {
        ArrayList<Pair<RelationshipType, Direction>> newTypes = new ArrayList<Pair<RelationshipType, Direction>>(this.orderedTypes.size());
        for (Pair<RelationshipType, Direction> pair : this.orderedTypes) {
            newTypes.add((Pair<RelationshipType, Direction>)Pair.of((Object)((RelationshipType)pair.first()), (Object)((Object)((Direction)((Object)pair.other())).reverse())));
        }
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    StandardExpander.RegularExpander createNew(Map<Direction, RelationshipType[]> newTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    ResourceIterator<Relationship> doExpand(Path path, BranchState state) {
        final Node node = path.endNode();
        return new NestingResourceIterator<Relationship, Pair<RelationshipType, Direction>>(this.orderedTypes.iterator()){

            protected ResourceIterator<Relationship> createNestedIterator(Pair<RelationshipType, Direction> entry) {
                RelationshipType type = (RelationshipType)entry.first();
                Direction dir = (Direction)((Object)entry.other());
                Iterable<Relationship> relationshipsIterable = dir == Direction.BOTH ? node.getRelationships(type) : node.getRelationships(dir, type);
                return Iterables.asResourceIterable(relationshipsIterable).iterator();
            }
        };
    }
}

