/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.asm.ClassReader;
import org.neo4j.codegen.asm.ClassVisitor;
import org.neo4j.codegen.asm.FieldVisitor;
import org.neo4j.codegen.asm.Handle;
import org.neo4j.codegen.asm.Label;
import org.neo4j.codegen.asm.MethodVisitor;
import org.neo4j.codegen.asm.Opcodes;
import org.neo4j.codegen.asm.Type;

public interface ByteCodeVisitor {
    public static final ByteCodeVisitor DO_NOTHING = (name, bytes) -> {};

    public void visitByteCode(String var1, ByteBuffer var2);

    public static Printer printer(final PrintWriter out) {
        return new Printer(){

            @Override
            void printf(String format, Object ... args) {
                out.format(format, args);
            }

            @Override
            void println(CharSequence line) {
                out.println(line);
            }
        };
    }

    public static Printer printer(final PrintStream out) {
        return new Printer(){

            @Override
            void printf(String format, Object ... args) {
                out.format(format, args);
            }

            @Override
            void println(CharSequence line) {
                out.println(line);
            }
        };
    }

    public static abstract class Printer
    extends ClassVisitor
    implements ByteCodeVisitor,
    CodeGeneratorOption {
        private Printer() {
            super(262144);
        }

        @Override
        public void applyTo(Object target) {
            if (target instanceof Configurable) {
                ((Configurable)target).addByteCodeVisitor(this);
            }
        }

        abstract void printf(String var1, Object ... var2);

        abstract void println(CharSequence var1);

        @Override
        public void visitByteCode(String name, ByteBuffer bytes) {
            new ClassReader(bytes.array()).accept(this, 0);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            StringBuilder iFaces = new StringBuilder();
            String prefix = " implements ";
            for (String iFace : interfaces) {
                iFaces.append(prefix).append(iFace);
                prefix = ", ";
            }
            this.printf("%s class %s extends %s%s%n{%n", Modifier.toString(access), name, superName, iFaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.printf("  %s %s %s%s;%n", Modifier.toString(access), Type.getType(desc).getClassName(), name, value == null ? "" : " = " + String.valueOf(value));
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.printf("  %s %s%s%n  {%n", Modifier.toString(access), name, desc);
            return new MethodVisitor(this.api){
                int offset;

                @Override
                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    int i;
                    StringBuilder frame = new StringBuilder().append("    [FRAME:");
                    switch (type) {
                        case -1: {
                            frame.append("NEW");
                            break;
                        }
                        case 0: {
                            frame.append("FULL");
                            break;
                        }
                        case 1: {
                            frame.append("APPEND");
                            break;
                        }
                        case 2: {
                            frame.append("CHOP");
                            break;
                        }
                        case 3: {
                            frame.append("SAME");
                            break;
                        }
                        case 4: {
                            frame.append("SAME1");
                            break;
                        }
                        default: {
                            frame.append(type);
                        }
                    }
                    frame.append(", ").append(nLocal).append(" locals: [");
                    String prefix = "";
                    for (i = 0; i < nLocal; ++i) {
                        frame.append(prefix);
                        if (local[i] instanceof String) {
                            frame.append(local[i]);
                        } else if (local[i] == Opcodes.TOP) {
                            frame.append("TOP");
                        } else if (local[i] == Opcodes.INTEGER) {
                            frame.append("INTEGER");
                        } else if (local[i] == Opcodes.FLOAT) {
                            frame.append("FLOAT");
                        } else if (local[i] == Opcodes.DOUBLE) {
                            frame.append("DOUBLE");
                        } else if (local[i] == Opcodes.LONG) {
                            frame.append("LONG");
                        } else if (local[i] == Opcodes.NULL) {
                            frame.append("NULL");
                        } else if (local[i] == Opcodes.UNINITIALIZED_THIS) {
                            frame.append("UNINITIALIZED_THIS");
                        } else {
                            frame.append(local[i]);
                        }
                        prefix = ", ";
                    }
                    frame.append("], ").append(nStack).append(" items on stack: [");
                    prefix = "";
                    for (i = 0; i < nStack; ++i) {
                        frame.append(prefix).append(stack[i]);
                        prefix = ", ";
                    }
                    this.println(frame.append(']'));
                }

                @Override
                public void visitInsn(int opcode) {
                    this.printf("    @%03d: %s%n", this.offset, Printer.opcode(opcode));
                    ++this.offset;
                }

                @Override
                public void visitIntInsn(int opcode, int operand) {
                    this.printf("    @%03d: %s %d%n", this.offset, Printer.opcode(opcode), operand);
                    this.offset += opcode == 17 ? 3 : 2;
                }

                @Override
                public void visitVarInsn(int opcode, int var) {
                    this.printf("    @%03d: %s var:%d%n", this.offset, Printer.opcode(opcode), var);
                    this.offset = var <= 3 ? ++this.offset : (var <= 255 ? (this.offset += 2) : (this.offset += 4));
                }

                @Override
                public void visitTypeInsn(int opcode, String type) {
                    this.printf("    @%03d: %s %s%n", this.offset, Printer.opcode(opcode), type);
                    this.offset += 3;
                }

                @Override
                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    this.printf("    @%03d: %s %s.%s:%s%n", this.offset, Printer.opcode(opcode), owner, name, desc);
                    this.offset += 3;
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    this.printf("    @%03d: %s %s.%s%s%n", this.offset, Printer.opcode(opcode), owner, name, desc);
                    this.offset += opcode == 185 ? 5 : 3;
                }

                @Override
                public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                    this.printf("    @%03d: InvokeDynamic %s%s / bsm:%s%s%n", this.offset, name, desc, bsm, Arrays.toString(bsmArgs));
                    this.offset += 5;
                }

                @Override
                public void visitJumpInsn(int opcode, Label label) {
                    this.printf("    @%03d: %s %s%n", this.offset, Printer.opcode(opcode), label);
                    this.offset += 3;
                }

                @Override
                public void visitLabel(Label label) {
                    this.printf("   %s:%n", label);
                }

                @Override
                public void visitLdcInsn(Object cst) {
                    this.printf("    @%03d: LDC %s%n", this.offset, cst);
                    this.offset += 2;
                }

                @Override
                public void visitIincInsn(int var, int increment) {
                    this.printf("    @%03d: IINC %d += %d%n", this.offset, var, increment);
                    this.offset = var <= 255 && increment <= 255 ? (this.offset += 3) : (this.offset += 6);
                }

                @Override
                public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                    this.printf("    @%03d: TABLE_SWITCH(min=%d, max=%d)%n    {%n", this.offset, min, max);
                    int i = 0;
                    int val = min;
                    while (i < labels.length) {
                        this.printf("      case %d goto %s%n", val, labels[i]);
                        ++i;
                        ++val;
                    }
                    this.printf("      default goto %s%n    }%n", dflt);
                    this.offset += 4 - (this.offset & 3);
                    this.offset += 12;
                    this.offset += 4 * labels.length;
                }

                @Override
                public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                    this.printf("    @%03d: LOOKUP_SWITCH%n    {%n", this.offset);
                    for (int i = 0; i < labels.length; ++i) {
                        this.printf("      case %d goto %s%n", keys[i], labels[i]);
                    }
                    this.printf("      default goto %s%n    }%n", dflt);
                    this.offset += 4 - (this.offset & 3);
                    this.offset += 8;
                    this.offset += 8 * labels.length;
                }

                @Override
                public void visitMultiANewArrayInsn(String desc, int dims) {
                    this.printf("    @%03d: MULTI_ANEW_ARRAY %s, dims:%d%n", this.offset, desc, dims);
                    this.offset += 4;
                }

                @Override
                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    this.printf("    [try/catch %s start@%s, end@%s, handler@%s]%n", type, start, end, handler);
                }

                @Override
                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    this.printf("    [local %s:%s, from %s to %s @offset=%d]%n", name, desc, start, end, index);
                }

                @Override
                public void visitLineNumber(int line, Label start) {
                    this.printf("    [line %d @ %s]%n", line, start);
                }

                @Override
                public void visitEnd() {
                    this.println("  }");
                }
            };
        }

        @Override
        public void visitEnd() {
            this.println("}");
        }

        private static String opcode(int opcode) {
            switch (opcode) {
                case 0: {
                    return "NOP";
                }
                case 1: {
                    return "ACONST_NULL";
                }
                case 2: {
                    return "ICONST_M1";
                }
                case 3: {
                    return "ICONST_0";
                }
                case 4: {
                    return "ICONST_1";
                }
                case 5: {
                    return "ICONST_2";
                }
                case 6: {
                    return "ICONST_3";
                }
                case 7: {
                    return "ICONST_4";
                }
                case 8: {
                    return "ICONST_5";
                }
                case 9: {
                    return "LCONST_0";
                }
                case 10: {
                    return "LCONST_1";
                }
                case 11: {
                    return "FCONST_0";
                }
                case 12: {
                    return "FCONST_1";
                }
                case 13: {
                    return "FCONST_2";
                }
                case 14: {
                    return "DCONST_0";
                }
                case 15: {
                    return "DCONST_1";
                }
                case 46: {
                    return "IALOAD";
                }
                case 47: {
                    return "LALOAD";
                }
                case 48: {
                    return "FALOAD";
                }
                case 49: {
                    return "DALOAD";
                }
                case 50: {
                    return "AALOAD";
                }
                case 51: {
                    return "BALOAD";
                }
                case 52: {
                    return "CALOAD";
                }
                case 53: {
                    return "SALOAD";
                }
                case 79: {
                    return "IASTORE";
                }
                case 80: {
                    return "LASTORE";
                }
                case 81: {
                    return "FASTORE";
                }
                case 82: {
                    return "DASTORE";
                }
                case 83: {
                    return "AASTORE";
                }
                case 84: {
                    return "BASTORE";
                }
                case 85: {
                    return "CASTORE";
                }
                case 86: {
                    return "SASTORE";
                }
                case 87: {
                    return "POP";
                }
                case 88: {
                    return "POP2";
                }
                case 89: {
                    return "DUP";
                }
                case 90: {
                    return "DUP_X1";
                }
                case 91: {
                    return "DUP_X2";
                }
                case 92: {
                    return "DUP2";
                }
                case 93: {
                    return "DUP2_X1";
                }
                case 94: {
                    return "DUP2_X2";
                }
                case 95: {
                    return "SWAP";
                }
                case 96: {
                    return "IADD";
                }
                case 97: {
                    return "LADD";
                }
                case 98: {
                    return "FADD";
                }
                case 99: {
                    return "DADD";
                }
                case 100: {
                    return "ISUB";
                }
                case 101: {
                    return "LSUB";
                }
                case 102: {
                    return "FSUB";
                }
                case 103: {
                    return "DSUB";
                }
                case 104: {
                    return "IMUL";
                }
                case 105: {
                    return "LMUL";
                }
                case 106: {
                    return "FMUL";
                }
                case 107: {
                    return "DMUL";
                }
                case 108: {
                    return "IDIV";
                }
                case 109: {
                    return "LDIV";
                }
                case 110: {
                    return "FDIV";
                }
                case 111: {
                    return "DDIV";
                }
                case 112: {
                    return "IREM";
                }
                case 113: {
                    return "LREM";
                }
                case 114: {
                    return "FREM";
                }
                case 115: {
                    return "DREM";
                }
                case 116: {
                    return "INEG";
                }
                case 117: {
                    return "LNEG";
                }
                case 118: {
                    return "FNEG";
                }
                case 119: {
                    return "DNEG";
                }
                case 120: {
                    return "ISHL";
                }
                case 121: {
                    return "LSHL";
                }
                case 122: {
                    return "ISHR";
                }
                case 123: {
                    return "LSHR";
                }
                case 124: {
                    return "IUSHR";
                }
                case 125: {
                    return "LUSHR";
                }
                case 126: {
                    return "IAND";
                }
                case 127: {
                    return "LAND";
                }
                case 128: {
                    return "IOR";
                }
                case 129: {
                    return "LOR";
                }
                case 130: {
                    return "IXOR";
                }
                case 131: {
                    return "LXOR";
                }
                case 133: {
                    return "I2L";
                }
                case 134: {
                    return "I2F";
                }
                case 135: {
                    return "I2D";
                }
                case 136: {
                    return "L2I";
                }
                case 137: {
                    return "L2F";
                }
                case 138: {
                    return "L2D";
                }
                case 139: {
                    return "F2I";
                }
                case 140: {
                    return "F2L";
                }
                case 141: {
                    return "F2D";
                }
                case 142: {
                    return "D2I";
                }
                case 143: {
                    return "D2L";
                }
                case 144: {
                    return "D2F";
                }
                case 145: {
                    return "I2B";
                }
                case 146: {
                    return "I2C";
                }
                case 147: {
                    return "I2S";
                }
                case 148: {
                    return "LCMP";
                }
                case 149: {
                    return "FCMPL";
                }
                case 150: {
                    return "FCMPG";
                }
                case 151: {
                    return "DCMPL";
                }
                case 152: {
                    return "DCMPG";
                }
                case 172: {
                    return "IRETURN";
                }
                case 173: {
                    return "LRETURN";
                }
                case 174: {
                    return "FRETURN";
                }
                case 175: {
                    return "DRETURN";
                }
                case 176: {
                    return "ARETURN";
                }
                case 177: {
                    return "RETURN";
                }
                case 190: {
                    return "ARRAYLENGTH";
                }
                case 191: {
                    return "ATHROW";
                }
                case 194: {
                    return "MONITORENTER";
                }
                case 195: {
                    return "MONITOREXIT";
                }
                case 16: {
                    return "BIPUSH";
                }
                case 17: {
                    return "SIPUSH";
                }
                case 188: {
                    return "NEWARRAY";
                }
                case 21: {
                    return "ILOAD";
                }
                case 22: {
                    return "LLOAD";
                }
                case 23: {
                    return "FLOAD";
                }
                case 24: {
                    return "DLOAD";
                }
                case 25: {
                    return "ALOAD";
                }
                case 54: {
                    return "ISTORE";
                }
                case 55: {
                    return "LSTORE";
                }
                case 56: {
                    return "FSTORE";
                }
                case 57: {
                    return "DSTORE";
                }
                case 58: {
                    return "ASTORE";
                }
                case 169: {
                    return "RET";
                }
                case 187: {
                    return "NEW";
                }
                case 189: {
                    return "ANEWARRAY";
                }
                case 192: {
                    return "CHECKCAST";
                }
                case 193: {
                    return "INSTANCEOF";
                }
                case 178: {
                    return "GETSTATIC";
                }
                case 179: {
                    return "PUTSTATIC";
                }
                case 180: {
                    return "GETFIELD";
                }
                case 181: {
                    return "PUTFIELD";
                }
                case 182: {
                    return "INVOKEVIRTUAL";
                }
                case 183: {
                    return "INVOKESPECIAL";
                }
                case 184: {
                    return "INVOKESTATIC";
                }
                case 185: {
                    return "INVOKEINTERFACE";
                }
                case 153: {
                    return "IFEQ";
                }
                case 154: {
                    return "IFNE";
                }
                case 155: {
                    return "IFLT";
                }
                case 156: {
                    return "IFGE";
                }
                case 157: {
                    return "IFGT";
                }
                case 158: {
                    return "IFLE";
                }
                case 159: {
                    return "IF_ICMPEQ";
                }
                case 160: {
                    return "IF_ICMPNE";
                }
                case 161: {
                    return "IF_ICMPLT";
                }
                case 162: {
                    return "IF_ICMPGE";
                }
                case 163: {
                    return "IF_ICMPGT";
                }
                case 164: {
                    return "IF_ICMPLE";
                }
                case 165: {
                    return "IF_ACMPEQ";
                }
                case 166: {
                    return "IF_ACMPNE";
                }
                case 167: {
                    return "GOTO";
                }
                case 168: {
                    return "JSR";
                }
                case 198: {
                    return "IFNULL";
                }
                case 199: {
                    return "IFNONNULL";
                }
            }
            throw new IllegalArgumentException("unknown opcode: " + opcode);
        }
    }

    public static class Multiplex
    implements ByteCodeVisitor {
        private final ByteCodeVisitor[] visitors;

        Multiplex(ByteCodeVisitor[] visitors) {
            this.visitors = visitors;
        }

        @Override
        public void visitByteCode(String name, ByteBuffer bytes) {
            for (ByteCodeVisitor visitor : this.visitors) {
                visitor.visitByteCode(name, bytes.duplicate());
            }
        }
    }

    public static interface Configurable {
        public void addByteCodeVisitor(ByteCodeVisitor var1);
    }
}

