/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingConstraint;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Numbers;

public final class SettingConstraints {
    public static final SettingConstraint<Long> POWER_OF_2 = new SettingConstraint<Long>(){

        @Override
        public void validate(Long value, Configuration config) {
            if (value != null && !Numbers.isPowerOfTwo((long)value)) {
                throw new IllegalArgumentException("only power of 2 values allowed");
            }
        }

        @Override
        public String getDescription() {
            return "is power of 2";
        }
    };
    public static final SettingConstraint<SocketAddress> HOSTNAME_ONLY = new SettingConstraint<SocketAddress>(){

        @Override
        public void validate(SocketAddress value, Configuration config) {
            if (value == null) {
                throw new IllegalArgumentException("can not be null");
            }
            if (value.getPort() >= 0) {
                throw new IllegalArgumentException("can not have a port");
            }
            if (StringUtils.isBlank((CharSequence)value.getHostname())) {
                throw new IllegalArgumentException("needs not a hostname");
            }
        }

        @Override
        public String getDescription() {
            return "has no specified port";
        }
    };
    public static final SettingConstraint<Path> ABSOLUTE_PATH = new SettingConstraint<Path>(){

        @Override
        public void validate(Path value, Configuration config) {
            if (!value.isAbsolute()) {
                throw new IllegalArgumentException(String.format("`%s` is not an absolute path.", this.valueToString(value)));
            }
        }

        @Override
        public String getDescription() {
            return "is absolute";
        }
    };

    private SettingConstraints() {
    }

    public static SettingConstraint<String> except(final String ... forbiddenValues) {
        return new SettingConstraint<String>(){

            @Override
            public void validate(String value, Configuration config) {
                if (StringUtils.isNotBlank((CharSequence)value) && ArrayUtils.contains((Object[])forbiddenValues, (Object)value)) {
                    throw new IllegalArgumentException(String.format("not allowed value is: %s", value));
                }
            }

            @Override
            public String getDescription() {
                if (forbiddenValues.length > 1) {
                    return String.format("is none of %s", Arrays.toString(forbiddenValues));
                }
                if (forbiddenValues.length == 1) {
                    return String.format("is not `%s`", forbiddenValues[0]);
                }
                return "";
            }
        };
    }

    public static SettingConstraint<String> matches(final String regex, final String description) {
        return new SettingConstraint<String>(){
            private final String descMsg;
            private final Pattern pattern;
            {
                this.descMsg = StringUtils.isEmpty((CharSequence)description) ? "" : String.format(" (%s)", description);
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public void validate(String value, Configuration config) {
                if (!this.pattern.matcher(value).matches()) {
                    throw new IllegalArgumentException(String.format("value does not match expression: `%s`%s", regex, this.descMsg));
                }
            }

            @Override
            public String getDescription() {
                return String.format("matches the pattern `%s`%s", regex, this.descMsg);
            }
        };
    }

    public static SettingConstraint<String> matches(String regex) {
        return SettingConstraints.matches(regex, null);
    }

    public static <T extends Comparable<T>> SettingConstraint<T> min(final T minValue) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (minValue.compareTo(value) > 0) {
                    throw new IllegalArgumentException(String.format("minimum allowed value is %s", this.valueToString(minValue)));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is minimum `%s`", this.valueToString(minValue));
            }
        };
    }

    public static <T extends Comparable<T>> SettingConstraint<T> max(final T maxValue) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (maxValue.compareTo(value) < 0) {
                    throw new IllegalArgumentException(String.format("maximum allowed value is %s", this.valueToString(maxValue)));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is maximum `%s`", this.valueToString(maxValue));
            }
        };
    }

    public static <T extends Comparable<T>> SettingConstraint<T> range(final T minValue, final T maxValue) {
        return new SettingConstraint<T>(){
            private SettingConstraint<T> max;
            private SettingConstraint<T> min;
            {
                this.max = SettingConstraints.max(maxValue);
                this.min = SettingConstraints.min(minValue);
            }

            @Override
            public void validate(T value, Configuration config) {
                this.min.validate(value, config);
                this.max.validate(value, config);
            }

            @Override
            public String getDescription() {
                return String.format("is in the range `%s` to `%s`", this.valueToString(minValue), this.valueToString(maxValue));
            }
        };
    }

    public static <T> SettingConstraint<T> is(final T expected) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
                if (!Objects.equals(value, expected)) {
                    throw new IllegalArgumentException(String.format("is not `%s`", this.valueToString(expected)));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is `%s`", this.valueToString(expected));
            }
        };
    }

    @SafeVarargs
    public static <T> SettingConstraint<T> any(final SettingConstraint<T> first, final SettingConstraint<T> ... rest) {
        return new SettingConstraint<T>(){
            private final SettingConstraint<T>[] constraints;
            {
                this.constraints = (SettingConstraint[])ArrayUtil.concat((Object)first, (Object[])rest);
            }

            @Override
            public void validate(T value, Configuration config) {
                for (SettingConstraint constraint : this.constraints) {
                    try {
                        constraint.validate(value, config);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                }
                throw new IllegalArgumentException(String.format("does not fulfill any of %s", this.getDescription()));
            }

            @Override
            public String getDescription() {
                return Arrays.stream(this.constraints).map(SettingConstraint::getDescription).collect(Collectors.joining(" or "));
            }

            @Override
            void setParser(SettingValueParser<T> parser) {
                super.setParser(parser);
                Arrays.stream(this.constraints).forEach(constraint -> constraint.setParser(parser));
            }
        };
    }

    public static <T> SettingConstraint<List<T>> size(final int size) {
        return new SettingConstraint<List<T>>(){

            @Override
            public void validate(List<T> value, Configuration config) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (value.size() != size) {
                    throw new IllegalArgumentException(String.format("needs to be of size %s", size));
                }
            }

            @Override
            public String getDescription() {
                return String.format("is of size `%s`", size);
            }
        };
    }

    public static <T> SettingConstraint<List<T>> minSize(final int size) {
        return new SettingConstraint<List<T>>(){

            @Override
            public void validate(List<T> value, Configuration config) {
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (value.size() <= size) {
                    throw new IllegalArgumentException(String.format("needs to be greater than size of %s", size));
                }
            }

            @Override
            public String getDescription() {
                return String.format("has minimum size `%s`", size);
            }
        };
    }

    public static <T, U> SettingConstraint<T> dependency(final SettingConstraint<T> ifconstraint, final SettingConstraint<T> elseconstraint, final Setting<U> dependency, final SettingConstraint<U> condition) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
                Object depValue = config.get(dependency);
                try {
                    condition.validate(depValue, config);
                }
                catch (IllegalArgumentException e) {
                    elseconstraint.validate(value, config);
                    return;
                }
                ifconstraint.validate(value, config);
            }

            @Override
            public String getDescription() {
                return String.format("depends on %s. If %s %s then it %s otherwise it %s.", dependency.name(), dependency.name(), condition.getDescription(), ifconstraint.getDescription(), elseconstraint.getDescription());
            }

            @Override
            void setParser(SettingValueParser<T> parser) {
                super.setParser(parser);
                ifconstraint.setParser(parser);
                elseconstraint.setParser(parser);
                condition.setParser(((SettingImpl)dependency).parser());
            }
        };
    }

    public static <T> SettingConstraint<T> unconstrained() {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
            }

            @Override
            public String getDescription() {
                return "is unconstrained";
            }
        };
    }

    public static SettingConstraint<Integer> greaterThanOrEqual(final Setting<Integer> other) {
        return new SettingConstraint<Integer>(){

            @Override
            public void validate(Integer value, Configuration config) {
                Integer otherValue = (Integer)config.get(other);
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (otherValue == null) {
                    throw new IllegalArgumentException(other.name() + " can not be null");
                }
                if (value < otherValue) {
                    throw new IllegalArgumentException(this.getDescription() + String.format("was %d, which is not more than or equal to %d", value, otherValue));
                }
            }

            @Override
            public String getDescription() {
                return String.format("Must be set greater than or equal to value of '%s'", other.name());
            }
        };
    }

    public static <T> SettingConstraint<T> lessThanOrEqual(final Function<T, Long> converter, final Setting<T> other, final LongFunction<Long> otherModifier, final String modifierDescription) {
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
                Object otherValue = config.get(other);
                if (value == null) {
                    throw new IllegalArgumentException("can not be null");
                }
                if (otherValue == null) {
                    throw new IllegalArgumentException(other.name() + " can not be null");
                }
                Long thisAsLong = (Long)converter.apply(value);
                Long otherAsLong = (Long)converter.apply(otherValue);
                if (thisAsLong == null) {
                    throw new IllegalStateException("Result of " + converter.toString() + " on " + value.toString() + " can not be null");
                }
                if (otherAsLong == null) {
                    throw new IllegalStateException("Result of " + converter.toString() + " on " + other.name() + " (" + otherValue.toString() + ") can not be null");
                }
                Long modifiedOther = (Long)otherModifier.apply(otherAsLong);
                if (modifiedOther == null) {
                    throw new IllegalStateException("Result of " + otherModifier.toString() + " on " + other.name() + " (" + otherAsLong + ") was null");
                }
                if (thisAsLong > modifiedOther) {
                    throw new IllegalArgumentException(this.getDescription() + String.format("was %d, which is not less than or equal to %d from %s", thisAsLong, modifiedOther, other.name()));
                }
            }

            @Override
            public String getDescription() {
                return String.format("Must be set less than or equal to value of '%s' %s", other.name(), modifierDescription);
            }
        };
    }

    public static <T> SettingConstraint<T> lessThanOrEqual(Function<T, Long> converter, Setting<T> other) {
        return SettingConstraints.lessThanOrEqual(converter, other, s -> s, "");
    }

    public static SettingConstraint<Integer> lessThanOrEqual(Setting<Integer> other) {
        return SettingConstraints.lessThanOrEqual(Long::valueOf, other);
    }

    public static <T> SettingConstraint<T> ifCluster(SettingConstraint<T> settingConstraint) {
        return SettingConstraints.ifMode(settingConstraint, SettingConstraints.ifStandaloneClusterEnabled(settingConstraint), GraphDatabaseSettings.Mode.CORE, GraphDatabaseSettings.Mode.READ_REPLICA);
    }

    public static <T> SettingConstraint<T> ifPrimary(SettingConstraint<T> settingConstraint) {
        return SettingConstraints.ifMode(settingConstraint, SettingConstraints.ifStandaloneClusterEnabled(settingConstraint), GraphDatabaseSettings.Mode.CORE);
    }

    public static <T> SettingConstraint<T> ifClusterCore(SettingConstraint<T> settingConstraint) {
        return SettingConstraints.ifMode(settingConstraint, SettingConstraints.unconstrained(), GraphDatabaseSettings.Mode.CORE);
    }

    private static <T> SettingConstraint<T> ifStandaloneClusterEnabled(SettingConstraint<T> settingConstraint) {
        return SettingConstraints.ifMode(SettingConstraints.dependency(settingConstraint, SettingConstraints.unconstrained(), GraphDatabaseSettings.enable_clustering_in_standalone, SettingConstraints.is(true)), SettingConstraints.unconstrained(), GraphDatabaseSettings.Mode.SINGLE);
    }

    private static <T> SettingConstraint<T> ifMode(SettingConstraint<T> modeConstraint, SettingConstraint<T> nonModeConstraint, GraphDatabaseSettings.Mode ... modes) {
        return SettingConstraints.dependency(modeConstraint, nonModeConstraint, GraphDatabaseSettings.mode, SettingConstraints.isOneOf(modes));
    }

    private static <T> SettingConstraint<T> isOneOf(final T[] acceptedValues) {
        if (acceptedValues == null || acceptedValues.length == 0) {
            throw new IllegalArgumentException("Accepted values must contain at least one object");
        }
        return new SettingConstraint<T>(){

            @Override
            public void validate(T value, Configuration config) {
                if (!ArrayUtil.contains((Object[])acceptedValues, value)) {
                    throw new IllegalArgumentException("is not " + this.getDescription());
                }
            }

            @Override
            public String getDescription() {
                return String.format("one of `%s`", Arrays.stream(acceptedValues).map(this::valueToString).collect(Collectors.joining(", ", "[", "]")));
            }
        };
    }

    public static <T, C extends Collection<T>> SettingConstraint<C> shouldNotContain(final T value, final String collectionDescription) {
        return new SettingConstraint<C>(){

            @Override
            public void validate(C coll, Configuration config) {
                if (coll.contains(value)) {
                    throw new IllegalArgumentException(this.getDescription());
                }
            }

            @Override
            public String getDescription() {
                return String.format("Value '%s' can't be included in %s!", value.toString(), collectionDescription);
            }
        };
    }
}

