/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Optional;
import java.util.regex.Pattern;
import org.neo4j.configuration.helpers.ConfigPatternBuilder;
import org.neo4j.configuration.helpers.DatabaseNameValidator;

public class DatabaseNamePattern {
    private final Optional<Pattern> regexPattern;
    private final String databaseName;

    public DatabaseNamePattern(String name) {
        DatabaseNameValidator.validateDatabaseNamePattern(name);
        this.regexPattern = ConfigPatternBuilder.optionalPatternFromConfigString(name.toLowerCase(), 2);
        this.databaseName = name;
    }

    public boolean matches(String value) {
        return this.regexPattern.map(p -> p.matcher(value).matches()).orElse(this.databaseName.equals(value));
    }

    public boolean containsPattern() {
        return this.regexPattern.isPresent();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        if (this.containsPattern()) {
            return "Database name pattern=" + this.databaseName;
        }
        return "Database name=" + this.databaseName;
    }
}

