/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.diagnostics;

import org.apache.commons.lang3.StringUtils;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.logging.Log;

public final class DiagnosticsManager {
    private static final int CAPTION_WIDTH = 80;
    private static final String NAME_START = "[ ";
    private static final String NAME_END = " ]";

    private DiagnosticsManager() {
    }

    public static <E extends Enum> void dump(Class<E> enumProvider, Log errorLog, DiagnosticsLogger diagnosticsLog) {
        for (Enum provider : (Enum[])enumProvider.getEnumConstants()) {
            DiagnosticsManager.dump((DiagnosticsProvider)((Object)provider), errorLog, diagnosticsLog);
        }
    }

    public static void dump(DiagnosticsProvider provider, Log errorLog, DiagnosticsLogger diagnosticsLog) {
        try {
            DiagnosticsManager.header(diagnosticsLog, provider.getDiagnosticsName());
            provider.dump(diagnosticsLog);
            diagnosticsLog.log("");
        }
        catch (Exception cause) {
            errorLog.error("Failure while logging diagnostics for " + String.valueOf(provider), (Throwable)cause);
        }
    }

    public static void section(DiagnosticsLogger diagnosticsLog, String sectionName) {
        diagnosticsLog.log("*".repeat(80));
        diagnosticsLog.log(StringUtils.center((String)DiagnosticsManager.title(sectionName), (int)80));
        diagnosticsLog.log("*".repeat(80));
    }

    private static void header(DiagnosticsLogger diagnosticsLog, String caption) {
        diagnosticsLog.log("-".repeat(80));
        diagnosticsLog.log(StringUtils.center((String)DiagnosticsManager.title(caption), (int)80));
        diagnosticsLog.log("-".repeat(80));
    }

    private static String title(String name) {
        return NAME_START + name + NAME_END;
    }
}

