/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.ExpressionCursors;
import org.neo4j.cypher.operations.InCache;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherFunctions {
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final String[] POINT_KEYS = new String[]{"crs", "x", "y", "z", "longitude", "latitude", "height", "srid"};

    private CypherFunctions() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static DoubleValue sin(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.sin(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sin()");
    }

    public static DoubleValue asin(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.asin(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("asin()");
    }

    public static DoubleValue haversin(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)((1.0 - Math.cos(((NumberValue)in).doubleValue())) / 2.0));
        }
        throw CypherFunctions.needsNumbers("haversin()");
    }

    public static DoubleValue cos(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.cos(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cos()");
    }

    public static DoubleValue cot(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)(1.0 / Math.tan(((NumberValue)in).doubleValue())));
        }
        throw CypherFunctions.needsNumbers("cot()");
    }

    public static DoubleValue acos(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.acos(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("acos()");
    }

    public static DoubleValue tan(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.tan(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("tan()");
    }

    public static DoubleValue atan(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.atan(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan()");
    }

    public static DoubleValue atan2(AnyValue y, AnyValue x) {
        assert (y != Values.NO_VALUE && x != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (y instanceof NumberValue && x instanceof NumberValue) {
            return Values.doubleValue((double)Math.atan2(((NumberValue)y).doubleValue(), ((NumberValue)x).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan2()");
    }

    public static DoubleValue ceil(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.ceil(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("ceil()");
    }

    public static DoubleValue floor(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.floor(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("floor()");
    }

    public static DoubleValue round(AnyValue in) {
        return CypherFunctions.round(in, (AnyValue)Values.ZERO_INT, (AnyValue)Values.stringValue((String)"HALF_UP"), (AnyValue)Values.booleanValue((boolean)false));
    }

    public static DoubleValue round(AnyValue in, AnyValue precision) {
        return CypherFunctions.round(in, precision, (AnyValue)Values.stringValue((String)"HALF_UP"), (AnyValue)Values.booleanValue((boolean)false));
    }

    public static DoubleValue round(AnyValue in, AnyValue precisionValue, AnyValue modeValue) {
        return CypherFunctions.round(in, precisionValue, modeValue, (AnyValue)Values.booleanValue((boolean)true));
    }

    public static DoubleValue round(AnyValue in, AnyValue precisionValue, AnyValue modeValue, AnyValue explicitModeValue) {
        RoundingMode mode;
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        assert (precisionValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(modeValue instanceof StringValue)) {
            throw CypherFunctions.notAModeString("round", modeValue);
        }
        try {
            mode = RoundingMode.valueOf(((StringValue)modeValue).stringValue());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException("Unknown rounding mode. Valid values are: CEILING, FLOOR, UP, DOWN, HALF_EVEN, HALF_UP, HALF_DOWN, UNNECESSARY.");
        }
        if (in instanceof NumberValue && precisionValue instanceof NumberValue) {
            int precision = CypherFunctions.asInt(precisionValue, () -> "Invalid input for precision value in function 'round()'");
            boolean explicitMode = ((BooleanValue)explicitModeValue).booleanValue();
            if (precision < 0) {
                throw new InvalidArgumentException("Precision argument to 'round()' cannot be negative");
            }
            if (precision == 0 && !explicitMode) {
                return Values.doubleValue((double)Math.round(((NumberValue)in).doubleValue()));
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(((NumberValue)in).doubleValue());
            int newScale = Math.min(bigDecimal.scale(), precision);
            return Values.doubleValue((double)bigDecimal.setScale(newScale, mode).doubleValue());
        }
        throw CypherFunctions.needsNumbers("round()");
    }

    public static NumberValue abs(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            if (in instanceof IntegralValue) {
                return Values.longValue((long)Math.abs(((NumberValue)in).longValue()));
            }
            return Values.doubleValue((double)Math.abs(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("abs()");
    }

    public static DoubleValue toDegrees(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.toDegrees(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toDegrees()");
    }

    public static DoubleValue exp(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.exp(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("exp()");
    }

    public static DoubleValue log(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.log(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log()");
    }

    public static DoubleValue log10(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.log10(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log10()");
    }

    public static DoubleValue toRadians(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.toRadians(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toRadians()");
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue) {
        return VirtualValues.range((long)CypherFunctions.asLong(startValue, () -> "Invalid input for start value in function 'range()'"), (long)CypherFunctions.asLong(endValue, () -> "Invalid input for end value in function 'range()'"), (long)1L);
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue, AnyValue stepValue) {
        long step = CypherFunctions.asLong(stepValue, () -> "Invalid input for step value in function 'range()'");
        if (step == 0L) {
            throw new InvalidArgumentException("Step argument to 'range()' cannot be zero");
        }
        return VirtualValues.range((long)CypherFunctions.asLong(startValue, () -> "Invalid input for start value in function 'range()'"), (long)CypherFunctions.asLong(endValue, () -> "Invalid input for end value in function 'range()'"), (long)step);
    }

    public static LongValue signum(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.longValue((long)((long)Math.signum(((NumberValue)in).doubleValue())));
        }
        throw CypherFunctions.needsNumbers("signum()");
    }

    public static DoubleValue sqrt(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.sqrt(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sqrt()");
    }

    public static DoubleValue rand() {
        return Values.doubleValue((double)ThreadLocalRandom.current().nextDouble());
    }

    public static TextValue randomUuid() {
        return Values.stringValue((String)UUID.randomUUID().toString());
    }

    public static Value distance(AnyValue lhs, AnyValue rhs) {
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherFunctions.calculateDistance((PointValue)lhs, (PointValue)rhs);
        }
        return Values.NO_VALUE;
    }

    public static Value withinBBox(AnyValue point, AnyValue lowerLeft, AnyValue upperRight) {
        if (point instanceof PointValue && lowerLeft instanceof PointValue && upperRight instanceof PointValue) {
            return CypherFunctions.withinBBox((PointValue)point, (PointValue)lowerLeft, (PointValue)upperRight);
        }
        return Values.NO_VALUE;
    }

    public static Value withinBBox(PointValue point, PointValue lowerLeft, PointValue upperRight) {
        CoordinateReferenceSystem crs = point.getCoordinateReferenceSystem();
        if (crs.equals((Object)lowerLeft.getCoordinateReferenceSystem()) && crs.equals((Object)upperRight.getCoordinateReferenceSystem())) {
            return Values.booleanValue((boolean)crs.getCalculator().withinBBox(point, lowerLeft, upperRight));
        }
        return Values.NO_VALUE;
    }

    public static VirtualNodeValue startNode(AnyValue anyValue, DbAccess access, RelationshipScanCursor cursor) {
        assert (anyValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (anyValue instanceof RelationshipValue) {
            return ((RelationshipValue)anyValue).startNode();
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            return CypherFunctions.startNode((VirtualRelationshipValue)anyValue, access, cursor);
        }
        throw new CypherTypeException(String.format("Invalid input for function 'startNode()': Expected %s to be a RelationshipValue", anyValue));
    }

    public static VirtualNodeValue startNode(VirtualRelationshipValue relationship, DbAccess access, RelationshipScanCursor cursor) {
        return VirtualValues.node((long)relationship.startNodeId(relationshipVisitor -> {
            access.singleRelationship(relationshipVisitor.id(), cursor);
            if (cursor.next()) {
                relationshipVisitor.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
            }
        }));
    }

    public static VirtualNodeValue endNode(AnyValue anyValue, DbAccess access, RelationshipScanCursor cursor) {
        assert (anyValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (anyValue instanceof RelationshipValue) {
            return ((RelationshipValue)anyValue).endNode();
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            return CypherFunctions.endNode((VirtualRelationshipValue)anyValue, access, cursor);
        }
        throw new CypherTypeException(String.format("Invalid input for function 'endNode()': Expected %s to be a RelationshipValue", anyValue));
    }

    public static VirtualNodeValue endNode(VirtualRelationshipValue relationship, DbAccess access, RelationshipScanCursor cursor) {
        return VirtualValues.node((long)relationship.endNodeId(relationshipVisitor -> {
            access.singleRelationship(relationshipVisitor.id(), cursor);
            if (cursor.next()) {
                relationshipVisitor.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
            }
        }));
    }

    public static VirtualNodeValue otherNode(AnyValue anyValue, DbAccess access, VirtualNodeValue node, RelationshipScanCursor cursor) {
        assert (anyValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (anyValue instanceof VirtualRelationshipValue) {
            return CypherFunctions.otherNode((VirtualRelationshipValue)anyValue, access, node, cursor);
        }
        throw new CypherTypeException(String.format("Expected %s to be a RelationshipValue", anyValue));
    }

    public static VirtualNodeValue otherNode(VirtualRelationshipValue relationship, DbAccess access, VirtualNodeValue node, RelationshipScanCursor cursor) {
        return VirtualValues.node((long)relationship.otherNodeId(node.id(), relationshipVisitor -> {
            access.singleRelationship(relationshipVisitor.id(), cursor);
            if (cursor.next()) {
                relationshipVisitor.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
            }
        }));
    }

    public static BooleanValue propertyExists(String key, AnyValue container, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeHasProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(key), nodeCursor, propertyCursor) ? Values.TRUE : Values.FALSE;
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipHasProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(key), relationshipScanCursor, propertyCursor) ? Values.TRUE : Values.FALSE;
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key) != Values.NO_VALUE ? Values.TRUE : Values.FALSE;
        }
        throw new CypherTypeException(String.format("Invalid input for function 'exists()': Expected %s to be a node, relationship or map", container));
    }

    public static AnyValue propertyGet(String key, AnyValue container, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(key), nodeCursor, propertyCursor, true);
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(key), relationshipScanCursor, propertyCursor, true);
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key);
        }
        if (container instanceof TemporalValue) {
            return ((TemporalValue)container).get(key);
        }
        if (container instanceof DurationValue) {
            return ((DurationValue)container).get(key);
        }
        if (container instanceof PointValue) {
            return ((PointValue)container).get(key);
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container));
    }

    public static AnyValue containerIndex(AnyValue container, AnyValue index, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (container != Values.NO_VALUE && index != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeProperty(((VirtualNodeValue)container).id(), CypherFunctions.propertyKeyId(dbAccess, index), nodeCursor, propertyCursor, true);
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipProperty(((VirtualRelationshipValue)container).id(), CypherFunctions.propertyKeyId(dbAccess, index), relationshipScanCursor, propertyCursor, true);
        }
        if (container instanceof MapValue) {
            return CypherFunctions.mapAccess((MapValue)container, index);
        }
        if (container instanceof SequenceValue) {
            return CypherFunctions.listAccess((SequenceValue)container, index);
        }
        throw new CypherTypeException(String.format("`%s` is not a collection or a map. Element access is only possible by performing a collection lookup using an integer index, or by performing a map lookup using a string key (found: %s[%s])", container, container, index));
    }

    public static boolean containerIndexExists(AnyValue container, AnyValue index, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (container != Values.NO_VALUE && index != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeHasProperty(((VirtualNodeValue)container).id(), CypherFunctions.propertyKeyId(dbAccess, index), nodeCursor, propertyCursor);
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipHasProperty(((VirtualRelationshipValue)container).id(), CypherFunctions.propertyKeyId(dbAccess, index), relationshipScanCursor, propertyCursor);
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).containsKey(CypherFunctions.asString(index, () -> "Cannot use non string value as or in map keys. It was " + index.toString()));
        }
        throw new CypherTypeException(String.format("`%s` is not a map. Element access is only possible by performing a collection lookup by performing a map lookup using a string key (found: %s[%s])", container, container, index));
    }

    public static AnyValue head(AnyValue container) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)container;
            if (sequence.length() == 0) {
                return Values.NO_VALUE;
            }
            return sequence.value(0);
        }
        throw new CypherTypeException(String.format("Invalid input for function 'head()': Expected %s to be a list", container));
    }

    public static ListValue tail(AnyValue container) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof ListValue) {
            return ((ListValue)container).tail();
        }
        if (container instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)container)).tail();
        }
        return VirtualValues.EMPTY_LIST;
    }

    public static AnyValue last(AnyValue container) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)container;
            int length = sequence.length();
            if (length == 0) {
                return Values.NO_VALUE;
            }
            return sequence.value(length - 1);
        }
        throw new CypherTypeException(String.format("Invalid input for function 'last()': Expected %s to be a list", container));
    }

    public static TextValue left(AnyValue in, AnyValue endPos) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            int len = CypherFunctions.asInt(endPos, () -> "Invalid input for length value in function 'left()'");
            return ((TextValue)in).substring(0, len);
        }
        throw CypherFunctions.notAString("left", in);
    }

    public static TextValue ltrim(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            return ((TextValue)in).ltrim();
        }
        throw CypherFunctions.notAString("ltrim", in);
    }

    public static TextValue rtrim(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            return ((TextValue)in).rtrim();
        }
        throw CypherFunctions.notAString("rtrim", in);
    }

    public static TextValue trim(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            return ((TextValue)in).trim();
        }
        throw CypherFunctions.notAString("trim", in);
    }

    public static TextValue replace(AnyValue original, AnyValue search, AnyValue replaceWith) {
        assert (original != Values.NO_VALUE && search != Values.NO_VALUE && replaceWith != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (original instanceof TextValue) {
            return ((TextValue)original).replace(CypherFunctions.asString(search), CypherFunctions.asString(replaceWith));
        }
        throw CypherFunctions.notAString("replace", original);
    }

    public static AnyValue reverse(AnyValue original) {
        assert (original != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (original instanceof TextValue) {
            return ((TextValue)original).reverse();
        }
        if (original instanceof ListValue) {
            return ((ListValue)original).reverse();
        }
        throw new CypherTypeException("Invalid input for function 'reverse()': Expected a string or a list; consider converting the value to a string with toString() or creating a list.");
    }

    public static TextValue right(AnyValue original, AnyValue length) {
        assert (original != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            int len = CypherFunctions.asInt(length, () -> "Invalid input for length value in function 'right()'");
            if (len < 0) {
                throw new IndexOutOfBoundsException("negative length");
            }
            int startVal = asText.length() - len;
            return asText.substring(Math.max(0, startVal));
        }
        throw CypherFunctions.notAString("right", original);
    }

    public static ListValue split(AnyValue original, AnyValue separator) {
        assert (original != Values.NO_VALUE && separator != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            if (asText.length() == 0) {
                return VirtualValues.list((AnyValue[])new AnyValue[]{Values.EMPTY_STRING});
            }
            if (separator instanceof ListValue) {
                ArrayList<String> separators = new ArrayList<String>();
                for (AnyValue s : (ListValue)separator) {
                    separators.add(CypherFunctions.asString(s));
                }
                return asText.split(separators);
            }
            return asText.split(CypherFunctions.asString(separator));
        }
        throw CypherFunctions.notAString("split", original);
    }

    public static TextValue substring(AnyValue original, AnyValue start) {
        assert (original != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asInt(start, () -> "Invalid input for start value in function 'substring()'"));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static TextValue substring(AnyValue original, AnyValue start, AnyValue length) {
        assert (original != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asInt(start, () -> "Invalid input for start value in function 'substring()'"), CypherFunctions.asInt(length, () -> "Invalid input for length value in function 'substring()'"));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static TextValue toLower(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            return ((TextValue)in).toLower();
        }
        throw CypherFunctions.notAString("toLower", in);
    }

    public static TextValue toUpper(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            return ((TextValue)in).toUpper();
        }
        throw CypherFunctions.notAString("toUpper", in);
    }

    public static LongValue id(AnyValue item) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof VirtualNodeValue) {
            return Values.longValue((long)((VirtualNodeValue)item).id());
        }
        if (item instanceof VirtualRelationshipValue) {
            return Values.longValue((long)((VirtualRelationshipValue)item).id());
        }
        throw new CypherTypeException(String.format("Invalid input for function 'id()': Expected %s to be a node or relationship, but it was `%s`", item, item.getTypeName()));
    }

    public static ListValue labels(AnyValue item, DbAccess access, NodeCursor nodeCursor) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof VirtualNodeValue) {
            return access.getLabelsForNode(((VirtualNodeValue)item).id(), nodeCursor);
        }
        throw new CypherTypeException("Invalid input for function 'labels()': Expected a Node, got: " + String.valueOf(item));
    }

    public static boolean hasLabel(AnyValue entity, int labelToken, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            return access.isLabelSetOnNode(labelToken, ((VirtualNodeValue)entity).id(), nodeCursor);
        }
        throw new CypherTypeException("Expected a Node, got: " + String.valueOf(entity));
    }

    public static boolean hasAnyLabel(AnyValue entity, int[] labels, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            return access.isAnyLabelSetOnNode(labels, ((VirtualNodeValue)entity).id(), nodeCursor);
        }
        throw new CypherTypeException("Expected a Node, got: " + String.valueOf(entity));
    }

    public static AnyValue type(AnyValue item, DbAccess access, RelationshipScanCursor relCursor) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof RelationshipValue) {
            return ((RelationshipValue)item).type();
        }
        if (item instanceof VirtualRelationshipValue) {
            int typeToken = ((VirtualRelationshipValue)item).relationshipTypeId(relationshipVisitor -> {
                long id = relationshipVisitor.id();
                access.singleRelationship(id, relCursor);
                if (relCursor.next() || access.relationshipDeletedInThisTransaction(id)) {
                    relationshipVisitor.visit(relCursor.sourceNodeReference(), relCursor.targetNodeReference(), relCursor.type());
                }
            });
            if (typeToken == -1) {
                return Values.NO_VALUE;
            }
            return Values.stringValue((String)access.relationshipTypeName(typeToken));
        }
        throw new CypherTypeException("Invalid input for function 'type()': Expected a Relationship, got: " + String.valueOf(item));
    }

    public static boolean hasType(AnyValue entity, int typeToken, DbAccess access, RelationshipScanCursor relCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualRelationshipValue) {
            if (typeToken == -1) {
                return false;
            }
            int actualType = ((VirtualRelationshipValue)entity).relationshipTypeId(relationshipVisitor -> {
                access.singleRelationship(relationshipVisitor.id(), relCursor);
                if (relCursor.next()) {
                    relationshipVisitor.visit(relCursor.sourceNodeReference(), relCursor.targetNodeReference(), relCursor.type());
                }
            });
            return typeToken == actualType;
        }
        throw new CypherTypeException("Expected a Relationship, got: " + String.valueOf(entity));
    }

    public static ListValue nodes(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof PathValue) {
            return VirtualValues.list((AnyValue[])((PathValue)in).nodes());
        }
        if (in instanceof VirtualPathValue) {
            long[] ids = ((VirtualPathValue)in).nodeIds();
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)ids.length);
            for (long id : ids) {
                builder.add((AnyValue)VirtualValues.node((long)id));
            }
            return builder.build();
        }
        throw new CypherTypeException(String.format("Invalid input for function 'nodes()': Expected %s to be a path", in));
    }

    public static ListValue relationships(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof PathValue) {
            return VirtualValues.list((AnyValue[])((PathValue)in).relationships());
        }
        if (in instanceof VirtualPathValue) {
            long[] ids = ((VirtualPathValue)in).relationshipIds();
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)ids.length);
            for (long id : ids) {
                builder.add((AnyValue)VirtualValues.relationship((long)id));
            }
            return builder.build();
        }
        throw new CypherTypeException(String.format("Invalid input for function 'relationships()': Expected %s to be a path", in));
    }

    public static Value point(AnyValue in, DbAccess access, ExpressionCursors cursors) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof VirtualNodeValue) {
            return CypherFunctions.asPoint(access, (VirtualNodeValue)in, cursors.nodeCursor(), cursors.propertyCursor());
        }
        if (in instanceof VirtualRelationshipValue) {
            return CypherFunctions.asPoint(access, (VirtualRelationshipValue)in, cursors.relationshipScanCursor(), cursors.propertyCursor());
        }
        if (in instanceof MapValue) {
            MapValue map = (MapValue)in;
            if (CypherFunctions.containsNull(map)) {
                return Values.NO_VALUE;
            }
            return PointValue.fromMap((MapValue)map);
        }
        throw new CypherTypeException(String.format("Invalid input for function 'point()': Expected a map but got %s", in));
    }

    public static ListValue keys(AnyValue in, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof VirtualNodeValue) {
            return CypherFunctions.extractKeys(access, access.nodePropertyIds(((VirtualNodeValue)in).id(), nodeCursor, propertyCursor));
        }
        if (in instanceof VirtualRelationshipValue) {
            return CypherFunctions.extractKeys(access, access.relationshipPropertyIds(((VirtualRelationshipValue)in).id(), relationshipScanCursor, propertyCursor));
        }
        if (in instanceof MapValue) {
            return ((MapValue)in).keys();
        }
        throw new CypherTypeException(String.format("Invalid input for function 'keys()': Expected a node, a relationship or a literal map but got %s", in));
    }

    public static MapValue properties(AnyValue in, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof VirtualNodeValue) {
            return access.nodeAsMap(((VirtualNodeValue)in).id(), nodeCursor, propertyCursor);
        }
        if (in instanceof VirtualRelationshipValue) {
            return access.relationshipAsMap(((VirtualRelationshipValue)in).id(), relationshipCursor, propertyCursor);
        }
        if (in instanceof MapValue) {
            return (MapValue)in;
        }
        throw new CypherTypeException(String.format("Invalid input for function 'properties()': Expected a node, a relationship or a literal map but got %s", in));
    }

    public static IntegralValue size(AnyValue item) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof TextValue) {
            return Values.longValue((long)((TextValue)item).length());
        }
        if (item instanceof SequenceValue) {
            return Values.longValue((long)((SequenceValue)item).length());
        }
        throw new CypherTypeException("Invalid input for function 'size()': Expected a String or List, got: " + String.valueOf(item));
    }

    public static BooleanValue isEmpty(AnyValue item) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof SequenceValue) {
            return Values.booleanValue((boolean)((SequenceValue)item).isEmpty());
        }
        if (item instanceof MapValue) {
            return Values.booleanValue((boolean)((MapValue)item).isEmpty());
        }
        if (item instanceof TextValue) {
            return Values.booleanValue((boolean)((TextValue)item).isEmpty());
        }
        throw new CypherTypeException("Invalid input for function 'isEmpty()': Expected a List, Map, or String, got: " + String.valueOf(item));
    }

    public static IntegralValue length(AnyValue item) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof VirtualPathValue) {
            return Values.longValue((long)((VirtualPathValue)item).size());
        }
        throw new CypherTypeException("Invalid input for function 'length()': Expected a Path, got: " + String.valueOf(item));
    }

    public static IntegralValue length3_5(AnyValue item) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof VirtualPathValue) {
            return CypherFunctions.length(item);
        }
        if (item instanceof TextValue || item instanceof SequenceValue) {
            return CypherFunctions.size(item);
        }
        throw new CypherTypeException("Invalid input for function 'length3_5()': Expected a Path, String or List, got: " + String.valueOf(item));
    }

    public static Value toBoolean(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof BooleanValue) {
            return (BooleanValue)in;
        }
        if (in instanceof TextValue) {
            switch (((TextValue)in).trim().stringValue().toLowerCase()) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            return Values.NO_VALUE;
        }
        if (in instanceof IntegralValue) {
            return ((IntegralValue)in).longValue() == 0L ? Values.FALSE : Values.TRUE;
        }
        throw new CypherTypeException("Invalid input for function 'toBoolean()': Expected a Boolean, Integer or String, got: " + String.valueOf(in));
    }

    public static Value toBooleanOrNull(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof BooleanValue || in instanceof TextValue || in instanceof IntegralValue) {
            return CypherFunctions.toBoolean(in);
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toBooleanList(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(in instanceof ListValue)) {
            throw new CypherTypeException(String.format("Invalid input for function 'toBooleanList()': Expected a List, got: %s", in));
        }
        ListValue lv = (ListValue)in;
        return (AnyValue)Arrays.stream(lv.asArray()).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toBooleanOrNull(entry)).collect(ListValueBuilder.collector());
    }

    public static Value toFloat(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof DoubleValue) {
            return (DoubleValue)in;
        }
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)((NumberValue)in).doubleValue());
        }
        if (in instanceof TextValue) {
            try {
                return Values.doubleValue((double)Double.parseDouble(((TextValue)in).stringValue()));
            }
            catch (NumberFormatException ignore) {
                return Values.NO_VALUE;
            }
        }
        throw new CypherTypeException("Invalid input for function 'toFloat()': Expected a String or Number, got: " + String.valueOf(in));
    }

    public static Value toFloatOrNull(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue || in instanceof TextValue) {
            return CypherFunctions.toFloat(in);
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toFloatList(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(in instanceof ListValue)) {
            throw new CypherTypeException(String.format("Invalid input for function 'toFloatList()': Expected a List, got: %s", in));
        }
        ListValue lv = (ListValue)in;
        return (AnyValue)Arrays.stream(lv.asArray()).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toFloatOrNull(entry)).collect(ListValueBuilder.collector());
    }

    public static Value toInteger(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof IntegralValue) {
            return (IntegralValue)in;
        }
        if (in instanceof NumberValue) {
            return Values.longValue((long)((NumberValue)in).longValue());
        }
        if (in instanceof TextValue) {
            return CypherFunctions.stringToLongValue((TextValue)in);
        }
        if (in instanceof BooleanValue) {
            if (((BooleanValue)in).booleanValue()) {
                return Values.longValue((long)1L);
            }
            return Values.longValue((long)0L);
        }
        throw new CypherTypeException("Invalid input for function 'toInteger()': Expected a String, Number or Boolean, got: " + String.valueOf(in));
    }

    public static Value toIntegerOrNull(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof NumberValue || in instanceof BooleanValue) {
            return CypherFunctions.toInteger(in);
        }
        if (in instanceof TextValue) {
            try {
                return CypherFunctions.stringToLongValue((TextValue)in);
            }
            catch (CypherTypeException e) {
                return Values.NO_VALUE;
            }
        }
        return Values.NO_VALUE;
    }

    public static ListValue toIntegerList(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof IntegralArray) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)in));
        }
        if (in instanceof FloatingPointArray) {
            return CypherFunctions.toIntegerList((FloatingPointArray)in);
        }
        if (in instanceof SequenceValue) {
            return CypherFunctions.toIntegerList((SequenceValue)in);
        }
        throw new CypherTypeException(String.format("Invalid input for function 'toIntegerList()': Expected a List, got: %s", in));
    }

    public static TextValue toString(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue) {
            return (TextValue)in;
        }
        if (in instanceof NumberValue) {
            return Values.stringValue((String)((NumberValue)in).prettyPrint());
        }
        if (in instanceof BooleanValue) {
            return Values.stringValue((String)((BooleanValue)in).prettyPrint());
        }
        if (in instanceof TemporalValue || in instanceof DurationValue || in instanceof PointValue) {
            return Values.stringValue((String)in.toString());
        }
        throw new CypherTypeException("Invalid input for function 'toString()': Expected a String, Number, Boolean, Temporal or Duration, got: " + String.valueOf(in));
    }

    public static AnyValue toStringOrNull(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (in instanceof TextValue || in instanceof NumberValue || in instanceof BooleanValue || in instanceof TemporalValue || in instanceof DurationValue || in instanceof PointValue) {
            return CypherFunctions.toString(in);
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toStringList(AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(in instanceof ListValue)) {
            throw new CypherTypeException(String.format("Invalid input for function 'toStringList()': Expected a List, got: %s", in));
        }
        ListValue lv = (ListValue)in;
        return (AnyValue)Arrays.stream(lv.asArray()).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toStringOrNull(entry)).collect(ListValueBuilder.collector());
    }

    public static ListValue fromSlice(AnyValue collection, AnyValue fromValue) {
        assert (collection != Values.NO_VALUE && fromValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        int from = CypherFunctions.asInt(fromValue);
        ListValue list = CypherFunctions.asList(collection);
        if (from >= 0) {
            return list.drop(from);
        }
        return list.drop(list.size() + from);
    }

    public static ListValue toSlice(AnyValue collection, AnyValue toValue) {
        assert (collection != Values.NO_VALUE && toValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        int from = CypherFunctions.asInt(toValue);
        ListValue list = CypherFunctions.asList(collection);
        if (from >= 0) {
            return list.take(from);
        }
        return list.take(list.size() + from);
    }

    public static ListValue fullSlice(AnyValue collection, AnyValue fromValue, AnyValue toValue) {
        assert (collection != Values.NO_VALUE && fromValue != Values.NO_VALUE && toValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        int from = CypherFunctions.asInt(fromValue);
        int to = CypherFunctions.asInt(toValue);
        ListValue list = CypherFunctions.asList(collection);
        int size = list.size();
        if (from >= 0 && to >= 0) {
            return list.slice(from, to);
        }
        if (from >= 0) {
            return list.slice(from, size + to);
        }
        if (to >= 0) {
            return list.slice(size + from, to);
        }
        return list.slice(size + from, size + to);
    }

    public static ListValue asList(AnyValue collection) {
        if (collection == Values.NO_VALUE) {
            return VirtualValues.EMPTY_LIST;
        }
        if (collection instanceof ListValue) {
            return (ListValue)collection;
        }
        if (collection instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)collection));
        }
        return VirtualValues.list((AnyValue[])new AnyValue[]{collection});
    }

    public static Value in(AnyValue findMe, AnyValue lookIn) {
        if (lookIn == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        Iterator iterator = CypherFunctions.asList(lookIn).iterator();
        if (!iterator.hasNext()) {
            return BooleanValue.FALSE;
        }
        if (findMe == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        boolean undefinedEquality = false;
        while (iterator.hasNext()) {
            AnyValue nextValue = (AnyValue)iterator.next();
            Equality equality = nextValue.ternaryEquals(findMe);
            if (equality == Equality.TRUE) {
                return BooleanValue.TRUE;
            }
            if (equality != Equality.UNDEFINED || undefinedEquality) continue;
            undefinedEquality = true;
        }
        return undefinedEquality ? Values.NO_VALUE : BooleanValue.FALSE;
    }

    public static Value in(AnyValue findMe, AnyValue lookIn, InCache cache, MemoryTracker memoryTracker) {
        if (lookIn == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        return cache.check(findMe, CypherFunctions.asList(lookIn), memoryTracker);
    }

    public static TextValue asTextValue(AnyValue value) {
        return CypherFunctions.asTextValue(value, null);
    }

    public static TextValue asTextValue(AnyValue value, Supplier<String> contextForErrorMessage) {
        if (!(value instanceof TextValue)) {
            String errorMessage = contextForErrorMessage == null ? String.format("Expected %s to be a %s, but it was a %s", value, TextValue.class.getName(), value.getClass().getName()) : String.format("%s: Expected %s to be a %s, but it was a %s", contextForErrorMessage.get(), value, TextValue.class.getName(), value.getClass().getName());
            throw new CypherTypeException(errorMessage);
        }
        return (TextValue)value;
    }

    private static Value stringToLongValue(TextValue in) {
        try {
            return Values.longValue((long)Long.parseLong(in.stringValue()));
        }
        catch (Exception e) {
            try {
                BigDecimal bigDecimal = new BigDecimal(in.stringValue());
                if (bigDecimal.compareTo(MAX_LONG) <= 0 && bigDecimal.compareTo(MIN_LONG) >= 0) {
                    return Values.longValue((long)bigDecimal.longValue());
                }
                throw new CypherTypeException(String.format("integer, %s, is too large", in.stringValue()));
            }
            catch (NumberFormatException ignore) {
                return Values.NO_VALUE;
            }
        }
    }

    private static ListValue extractKeys(DbAccess access, int[] keyIds) {
        String[] keysNames = new String[keyIds.length];
        for (int i = 0; i < keyIds.length; ++i) {
            keysNames[i] = access.getPropertyKeyName(keyIds[i]);
        }
        return VirtualValues.fromArray((ArrayValue)Values.stringArray((String[])keysNames));
    }

    private static Value asPoint(DbAccess access, VirtualNodeValue nodeValue, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value = access.nodeProperty(nodeValue.id(), access.propertyKey(key), nodeCursor, propertyCursor, true);
            if (value == Values.NO_VALUE) continue;
            builder.add(key, (AnyValue)value);
        }
        return PointValue.fromMap((MapValue)builder.build());
    }

    private static Value asPoint(DbAccess access, VirtualRelationshipValue relationshipValue, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value = access.relationshipProperty(relationshipValue.id(), access.propertyKey(key), relationshipScanCursor, propertyCursor, true);
            if (value == Values.NO_VALUE) continue;
            builder.add(key, (AnyValue)value);
        }
        return PointValue.fromMap((MapValue)builder.build());
    }

    private static boolean containsNull(MapValue map) {
        boolean[] hasNull = new boolean[]{false};
        map.foreach((s, value) -> {
            if (value == Values.NO_VALUE) {
                hasNull[0] = true;
            }
        });
        return hasNull[0];
    }

    private static AnyValue listAccess(SequenceValue container, AnyValue index) {
        NumberValue number = CypherFunctions.asNumberValue(index, () -> "Cannot access a list '" + container.toString() + "' using a non-number index, got " + index.toString());
        if (!(number instanceof IntegralValue)) {
            throw new CypherTypeException(String.format("Cannot access a list using an non-integer number index, got %s", number), null);
        }
        long idx = number.longValue();
        if (idx > Integer.MAX_VALUE || idx < Integer.MIN_VALUE) {
            throw new InvalidArgumentException(String.format("Cannot index a list using a value greater than %d or lesser than %d, got %d", Integer.MAX_VALUE, Integer.MIN_VALUE, idx));
        }
        if (idx < 0L) {
            idx = (long)container.length() + idx;
        }
        if (idx >= (long)container.length() || idx < 0L) {
            return Values.NO_VALUE;
        }
        return container.value((int)idx);
    }

    private static int propertyKeyId(DbAccess dbAccess, AnyValue index) {
        return dbAccess.propertyKey(CypherFunctions.asString(index, () -> "Cannot use a property key with non string name. It was " + index.toString()));
    }

    private static AnyValue mapAccess(MapValue container, AnyValue index) {
        return container.get(CypherFunctions.asString(index, () -> "Cannot access a map '" + container.toString() + "' by key '" + index.toString() + "'"));
    }

    private static String asString(AnyValue value) {
        return CypherFunctions.asTextValue(value).stringValue();
    }

    private static String asString(AnyValue value, Supplier<String> contextForErrorMessage) {
        return CypherFunctions.asTextValue(value, contextForErrorMessage).stringValue();
    }

    private static NumberValue asNumberValue(AnyValue value, Supplier<String> contextForErrorMessage) {
        if (!(value instanceof NumberValue)) {
            throw new CypherTypeException(String.format("%s: Expected %s to be a %s, but it was a %s", contextForErrorMessage.get(), value, NumberValue.class.getName(), value.getClass().getName()));
        }
        return (NumberValue)value;
    }

    private static Value calculateDistance(PointValue p1, PointValue p2) {
        if (p1.getCoordinateReferenceSystem().equals((Object)p2.getCoordinateReferenceSystem())) {
            return Values.doubleValue((double)p1.getCoordinateReferenceSystem().getCalculator().distance(p1, p2));
        }
        return Values.NO_VALUE;
    }

    private static long asLong(AnyValue value, Supplier<String> contextForErrorMessage) {
        if (value instanceof NumberValue) {
            return ((NumberValue)value).longValue();
        }
        String errorMsg = contextForErrorMessage == null ? "Expected a numeric value but got: " + String.valueOf(value) : contextForErrorMessage.get() + ": Expected a numeric value but got: " + String.valueOf(value);
        throw new CypherTypeException(errorMsg);
    }

    public static int asInt(AnyValue value) {
        return CypherFunctions.asInt(value, null);
    }

    public static int asInt(AnyValue value, Supplier<String> contextForErrorMessage) {
        return (int)CypherFunctions.asLong(value, contextForErrorMessage);
    }

    public static long nodeId(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (value instanceof VirtualNodeValue) {
            return ((VirtualNodeValue)value).id();
        }
        throw new CypherTypeException("Expected VirtualNodeValue got " + value.getClass().getName());
    }

    public static BooleanValue assertIsNode(AnyValue item) {
        assert (item != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (item instanceof VirtualNodeValue) {
            return Values.TRUE;
        }
        throw new CypherTypeException("Expected a Node, got: " + String.valueOf(item));
    }

    private static CypherTypeException needsNumbers(String method) {
        return new CypherTypeException(String.format("%s requires numbers", method));
    }

    private static CypherTypeException notAString(String method, AnyValue in) {
        assert (in != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        return new CypherTypeException(String.format("Expected a string value for `%s`, but got: %s; consider converting it to a string with toString().", method, in));
    }

    private static CypherTypeException notAModeString(String method, AnyValue mode) {
        assert (mode != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        return new CypherTypeException(String.format("Expected a string value for `%s`, but got: %s.", method, mode));
    }

    private static ListValue toIntegerList(FloatingPointArray array) {
        ListValueBuilder converted = ListValueBuilder.newListBuilder((int)array.length());
        for (int i = 0; i < array.length(); ++i) {
            converted.add((AnyValue)Values.longValue((long)((long)array.doubleValue(i))));
        }
        return converted.build();
    }

    private static ListValue toIntegerList(SequenceValue sequenceValue) {
        ListValueBuilder converted = ListValueBuilder.newListBuilder();
        for (AnyValue value : sequenceValue) {
            converted.add((AnyValue)(value != Values.NO_VALUE ? CypherFunctions.toIntegerOrNull(value) : Values.NO_VALUE));
        }
        return converted.build();
    }
}

