/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.UnexpectedEndOfInputException;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.helpers.Exceptions;

public class CsvInputParser
implements Closeable {
    private final CharSeeker seeker;
    private final Mark mark = new Mark();
    private final IdType idType;
    private final Header header;
    private final int delimiter;
    private final Collector badCollector;
    private final Extractor<String> stringExtractor;
    private long lineNumber;

    public CsvInputParser(CharSeeker seeker, int delimiter, IdType idType, Header header, Collector badCollector, Extractors extractors) {
        this.seeker = seeker;
        this.delimiter = delimiter;
        this.idType = idType;
        this.header = header;
        this.badCollector = badCollector;
        this.stringExtractor = extractors.string();
    }

    boolean next(InputEntityVisitor visitor) throws IOException {
        ++this.lineNumber;
        int i = 0;
        Header.Entry entry = null;
        Header.Entry[] entries = this.header.entries();
        try {
            boolean doContinue = true;
            for (i = 0; i < entries.length && doContinue; ++i) {
                entry = entries[i];
                if (!this.seeker.seek(this.mark, this.delimiter)) {
                    if (i > 0) {
                        throw new UnexpectedEndOfInputException("Near " + String.valueOf(this.mark));
                    }
                    return false;
                }
                block2 : switch (entry.type()) {
                    case ID: {
                        if (!this.seeker.tryExtract(this.mark, entry.extractor())) break;
                        switch (this.idType) {
                            case STRING: 
                            case INTEGER: {
                                Object idValue = entry.extractor().value();
                                doContinue = visitor.id(idValue, entry.group());
                                if (entry.name() == null) break block2;
                                doContinue = visitor.property(entry.name(), idValue);
                                break block2;
                            }
                            case ACTUAL: {
                                doContinue = visitor.id(((Extractors.LongExtractor)entry.extractor()).longValue());
                                break block2;
                            }
                            default: {
                                throw new IllegalArgumentException(this.idType.name());
                            }
                        }
                    }
                    case START_ID: {
                        if (!this.seeker.tryExtract(this.mark, entry.extractor())) break;
                        switch (this.idType) {
                            case STRING: {
                                doContinue = visitor.startId(entry.extractor().value(), entry.group());
                                break block2;
                            }
                            case INTEGER: {
                                doContinue = visitor.startId(entry.extractor().value(), entry.group());
                                break block2;
                            }
                            case ACTUAL: {
                                doContinue = visitor.startId(((Extractors.LongExtractor)entry.extractor()).longValue());
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException(this.idType.name());
                    }
                    case END_ID: {
                        if (!this.seeker.tryExtract(this.mark, entry.extractor())) break;
                        switch (this.idType) {
                            case STRING: {
                                doContinue = visitor.endId(entry.extractor().value(), entry.group());
                                break block2;
                            }
                            case INTEGER: {
                                doContinue = visitor.endId(entry.extractor().value(), entry.group());
                                break block2;
                            }
                            case ACTUAL: {
                                doContinue = visitor.endId(((Extractors.LongExtractor)entry.extractor()).longValue());
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException(this.idType.name());
                    }
                    case TYPE: {
                        if (!this.seeker.tryExtract(this.mark, entry.extractor())) break;
                        doContinue = visitor.type((String)entry.extractor().value());
                        break;
                    }
                    case PROPERTY: {
                        Object value;
                        if (!this.seeker.tryExtract(this.mark, entry.extractor(), entry.optionalParameter()) || CsvInputParser.isEmptyArray(value = entry.extractor().value())) break;
                        doContinue = visitor.property(entry.name(), value);
                        break;
                    }
                    case LABEL: {
                        if (!this.seeker.tryExtract(this.mark, entry.extractor())) break;
                        Object labelsValue = entry.extractor().value();
                        if (labelsValue.getClass().isArray()) {
                            doContinue = visitor.labels((String[])labelsValue);
                            break;
                        }
                        doContinue = visitor.labels(new String[]{(String)labelsValue});
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(entry.type().toString());
                    }
                }
                if (this.mark.isEndOfLine()) break;
            }
            while (!this.mark.isEndOfLine()) {
                this.seeker.seek(this.mark, this.delimiter);
                if (!doContinue) continue;
                this.seeker.tryExtract(this.mark, this.stringExtractor, entry.optionalParameter());
                this.badCollector.collectExtraColumns(this.seeker.sourceDescription(), this.lineNumber, (String)this.stringExtractor.value());
            }
            visitor.endOfEntity();
            return true;
        }
        catch (RuntimeException e) {
            String stringValue = null;
            try {
                Extractors extractors = new Extractors('?');
                if (this.seeker.tryExtract(this.mark, extractors.string(), entry.optionalParameter())) {
                    stringValue = (String)extractors.string().value();
                }
            }
            catch (Exception extractors) {
                // empty catch block
            }
            String message = String.format("ERROR in input%n  data source: %s%n  in field: %s%n  for header: %s%n  raw field value: %s%n  original error: %s", this.seeker, String.valueOf(entry) + ":" + (i + 1), this.header, stringValue != null ? stringValue : "??", e.getMessage());
            if (e instanceof InputException) {
                throw (RuntimeException)Exceptions.withMessage((Throwable)e, (String)message);
            }
            throw new InputException(message, e);
        }
    }

    private static boolean isEmptyArray(Object value) {
        return value.getClass().isArray() && Array.getLength(value) == 0;
    }

    @Override
    public void close() throws IOException {
        this.seeker.close();
    }
}

