/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

public final class NumberAwareStringComparator
implements Comparator<String> {
    public static final Comparator<String> INSTANCE = new NumberAwareStringComparator();

    private NumberAwareStringComparator() {
    }

    @Override
    public int compare(String o1, String o2) {
        Iterator<Comparable> c1 = NumberAwareStringComparator.comparables(o1);
        Iterator<Comparable> c2 = NumberAwareStringComparator.comparables(o2);
        boolean c1Has = c1.hasNext();
        boolean c2Has = c2.hasNext();
        while (c1Has || c2Has) {
            if (!c1Has) {
                return -1;
            }
            if (!c2Has) {
                return 1;
            }
            int diff = c1.next().compareTo(c2.next());
            if (diff != 0) {
                return diff;
            }
            c1Has = c1.hasNext();
            c2Has = c2.hasNext();
        }
        return 0;
    }

    private static Iterator<Comparable> comparables(final String string) {
        return new PrefetchingIterator<Comparable>(){
            private int index;

            @Override
            protected Comparable fetchNextOrNull() {
                if (this.index >= string.length()) {
                    return null;
                }
                int startIndex = this.index;
                char ch = string.charAt(this.index);
                boolean isNumber = Character.isDigit(ch);
                while (Character.isDigit(ch) == isNumber && ++this.index < string.length()) {
                    ch = string.charAt(this.index);
                }
                String substring = string.substring(startIndex, this.index);
                return isNumber ? new BigInteger(substring) : substring;
            }
        };
    }
}

