/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.procedure.builtin.BuiltInProcedures;

public class IndexProcedures {
    private final KernelTransaction ktx;
    private final IndexingService indexingService;

    public IndexProcedures(KernelTransaction tx, IndexingService indexingService) {
        this.ktx = tx;
        this.indexingService = indexingService;
    }

    void awaitIndexByName(String indexName, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        IndexDescriptor index = this.getIndex(indexName);
        this.waitUntilOnline(index, timeout, timeoutUnits);
    }

    void resampleIndex(String indexName) throws ProcedureException {
        IndexDescriptor index = this.getIndex(indexName);
        this.triggerSampling(index);
    }

    void resampleOutdatedIndexes() {
        this.indexingService.triggerIndexSampling(IndexSamplingMode.backgroundRebuildUpdated());
    }

    void resampleOutdatedIndexes(long timeOutSeconds) {
        long millis = TimeUnit.SECONDS.toMillis(timeOutSeconds);
        IndexSamplingMode mode = IndexSamplingMode.foregroundRebuildUpdated((long)millis);
        this.indexingService.triggerIndexSampling(mode);
    }

    public Stream<BuiltInProcedures.SchemaIndexInfo> createIndex(String indexName, List<String> labels, List<String> properties, IndexProviderDescriptor indexProviderDescriptor, Map<String, Object> configMap) throws ProcedureException {
        return this.createIndex(indexName, labels, properties, indexProviderDescriptor, configMap, "index created", (schemaWrite, name, descriptor, provider, indexConfig) -> {
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)descriptor, (IndexProviderDescriptor)provider).withName(name).withIndexConfig(indexConfig);
            schemaWrite.indexCreate(prototype);
        });
    }

    public Stream<BuiltInProcedures.SchemaIndexInfo> createUniquePropertyConstraint(String constraintName, List<String> labels, List<String> properties, IndexProviderDescriptor indexProviderDescriptor, Map<String, Object> configMap) throws ProcedureException {
        return this.createIndex(constraintName, labels, properties, indexProviderDescriptor, configMap, "uniqueness constraint online", (schemaWrite, name, schema, provider, indexConfig) -> {
            IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)provider).withName(name).withIndexConfig(indexConfig);
            schemaWrite.uniquePropertyConstraintCreate(prototype);
        });
    }

    public Stream<BuiltInProcedures.SchemaIndexInfo> createNodeKey(String constraintName, List<String> labels, List<String> properties, IndexProviderDescriptor indexProviderDescriptor, Map<String, Object> configMap) throws ProcedureException {
        return this.createIndex(constraintName, labels, properties, indexProviderDescriptor, configMap, "node key constraint online", (schemaWrite, name, schema, provider, indexConfig) -> {
            IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)provider).withName(name).withIndexConfig(indexConfig);
            schemaWrite.nodeKeyConstraintCreate(prototype);
        });
    }

    private Stream<BuiltInProcedures.SchemaIndexInfo> createIndex(String name, List<String> labels, List<String> properties, IndexProviderDescriptor indexProviderDescriptor, Map<String, Object> configMap, String statusMessage, IndexCreator indexCreator) throws ProcedureException {
        IndexConfig indexConfig = IndexSettingUtil.toIndexConfigFromStringObjectMap(configMap);
        IndexProcedures.assertSingleLabel(labels);
        IndexProcedures.assertValidIndexProvider(indexProviderDescriptor);
        int labelId = this.getOrCreateLabelId(labels.get(0));
        int[] propertyKeyIds = this.getOrCreatePropertyIds(properties);
        try {
            SchemaWrite schemaWrite = this.ktx.schemaWrite();
            LabelSchemaDescriptor labelSchemaDescriptor = SchemaDescriptors.forLabel((int)labelId, (int[])propertyKeyIds);
            indexCreator.create(schemaWrite, name, labelSchemaDescriptor, indexProviderDescriptor, indexConfig);
            return Stream.of(new BuiltInProcedures.SchemaIndexInfo(name, labels, properties, indexProviderDescriptor.name(), statusMessage));
        }
        catch (KernelException e) {
            throw new ProcedureException(e.status(), (Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private static void assertValidIndexProvider(IndexProviderDescriptor indexProviderDescriptor) throws ProcedureException {
        if (indexProviderDescriptor == FulltextIndexProviderFactory.DESCRIPTOR) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Could not create index with specified index provider '%s'. To create fulltext index, please use '%s'.", new Object[]{indexProviderDescriptor.name(), "CREATE FULLTEXT INDEX ..."});
        }
        if (indexProviderDescriptor != GenericNativeIndexProvider.DESCRIPTOR && indexProviderDescriptor != NativeLuceneFusionIndexProviderFactory30.DESCRIPTOR) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Could not create index with specified index provider '%s'.", new Object[]{indexProviderDescriptor.name()});
        }
    }

    private static void assertSingleLabel(List<String> labels) throws ProcedureException {
        if (labels.size() != 1) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Could not create index with specified label(s), need to provide exactly one but was " + String.valueOf(labels), new Object[0]);
        }
    }

    private int getOrCreateLabelId(String labelName) throws ProcedureException {
        try {
            return this.ktx.tokenWrite().labelGetOrCreateForName(labelName);
        }
        catch (KernelException e) {
            throw new ProcedureException(e.status(), (Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private int[] getOrCreatePropertyIds(List<String> propertyKeyNames) throws ProcedureException {
        int[] propertyKeyIds = new int[propertyKeyNames.size()];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            try {
                propertyKeyIds[i] = this.ktx.tokenWrite().propertyKeyGetOrCreateForName(propertyKeyNames.get(i));
                continue;
            }
            catch (KernelException e) {
                throw new ProcedureException(e.status(), (Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        return propertyKeyIds;
    }

    private IndexDescriptor getIndex(String indexName) throws ProcedureException {
        IndexDescriptor indexReference = this.ktx.schemaRead().indexGetForName(indexName);
        if (indexReference == IndexDescriptor.NO_INDEX) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, "No such index '%s'", new Object[]{indexName});
        }
        return indexReference;
    }

    private void waitUntilOnline(IndexDescriptor index, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        try {
            Predicates.awaitEx(() -> this.isOnline(index), (long)timeout, (TimeUnit)timeoutUnits);
        }
        catch (TimeoutException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureTimedOut, "Index on '%s' did not come online within %s %s", new Object[]{index.userDescription((TokenNameLookup)this.ktx.tokenRead()), timeout, timeoutUnits});
        }
    }

    private boolean isOnline(IndexDescriptor index) throws ProcedureException {
        InternalIndexState state = this.getState(index);
        switch (state) {
            case POPULATING: {
                return false;
            }
            case ONLINE: {
                return true;
            }
            case FAILED: {
                String cause = this.getFailure(index);
                throw new ProcedureException((Status)Status.Schema.IndexCreationFailed, IndexPopulationFailure.appendCauseOfFailure((String)"Index '%s' is in failed state.", (String)cause), new Object[]{index.getName()});
            }
        }
        throw new IllegalStateException("Unknown index state " + String.valueOf(state));
    }

    private InternalIndexState getState(IndexDescriptor index) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetState(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No such index %s", new Object[]{index.getName()});
        }
    }

    private String getFailure(IndexDescriptor index) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetFailure(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No such index %s", new Object[]{index.getName()});
        }
    }

    private void triggerSampling(IndexDescriptor index) {
        this.indexingService.triggerIndexSampling(index, IndexSamplingMode.backgroundRebuildAll());
    }

    @FunctionalInterface
    private static interface IndexCreator {
        public void create(SchemaWrite var1, String var2, LabelSchemaDescriptor var3, IndexProviderDescriptor var4, IndexConfig var5) throws KernelException;
    }
}

