/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.CommandHelpers;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.TransactionIdStore;
import picocli.CommandLine;

@CommandLine.Command(name="store-info", header={"Print information about a Neo4j database store."}, description={"Print information about a Neo4j database store, such as what version of Neo4j created it."})
public class StoreInfoCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--structured"}, arity="0", description={"Return result structured as json"})
    private boolean structured;
    @CommandLine.Option(names={"--all"}, arity="0", description={"Return store info for all databases at provided path"})
    private boolean all;
    @CommandLine.Parameters(description={"Path to database store files, or databases directory if --all option is used"})
    private Path path;
    private final StorageEngineFactory.Selector storageEngineSelector;

    public StoreInfoCommand(ExecutionContext ctx) {
        this(ctx, StorageEngineFactory.SELECTOR);
    }

    StoreInfoCommand(ExecutionContext ctx, StorageEngineFactory.Selector storageEngineSelector) {
        super(ctx);
        this.storageEngineSelector = storageEngineSelector;
    }

    public void execute() {
        Config config = CommandHelpers.buildConfig(this.ctx, this.allowCommandExpansion);
        Neo4jLayout neo4jLayout = Neo4jLayout.of((Config)config);
        try (FileSystemAbstraction fs = this.ctx.fs();
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler, (PageCacheTracer)PageCacheTracer.NULL);){
            this.validatePath(fs, pageCache, this.all, this.path, neo4jLayout);
            if (this.all) {
                Collector<CharSequence, ?, String> collector = this.structured ? Collectors.joining(",", "[", "]") : Collectors.joining(System.lineSeparator() + System.lineSeparator());
                String result = Arrays.stream(fs.listFiles(this.path)).sorted(Comparator.comparing(Path::getFileName)).map(dbPath -> neo4jLayout.databaseLayout(dbPath.getFileName().toString())).filter(dbLayout -> this.storageEngineSelector.selectStorageEngine(fs, dbLayout, pageCache).isPresent()).map(dbLayout -> this.printInfo(fs, (DatabaseLayout)dbLayout, pageCache, config, this.structured, true)).collect(collector);
                this.ctx.out().println(result);
            } else {
                DatabaseLayout databaseLayout = neo4jLayout.databaseLayout(this.path.getFileName().toString());
                this.ctx.out().println(this.printInfo(fs, databaseLayout, pageCache, config, this.structured, false));
            }
        }
        catch (CommandFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandFailedException(String.format("Failed to execute command: '%s'.", e.getMessage()), (Throwable)e);
        }
    }

    private void validatePath(FileSystemAbstraction fs, PageCache pageCache, boolean all, Path storePath, Neo4jLayout neo4jLayout) {
        if (!fs.isDirectory(storePath)) {
            throw new IllegalArgumentException(String.format("Provided path %s must point to a directory.", storePath.toAbsolutePath()));
        }
        String dirName = storePath.getFileName().toString();
        DatabaseLayout databaseLayout = neo4jLayout.databaseLayout(dirName);
        boolean pathIsDatabase = this.storageEngineSelector.selectStorageEngine(fs, databaseLayout, pageCache).isPresent();
        if (all && pathIsDatabase) {
            throw new IllegalArgumentException(String.format("You used the --all option but directory %s contains the store files of a single database, rather than several database directories.", storePath.toAbsolutePath()));
        }
        if (!all && !pathIsDatabase) {
            throw new IllegalArgumentException(String.format("Directory %s does not contain the store files of a database, but you did not use the --all option.", storePath.toAbsolutePath()));
        }
    }

    private String printInfo(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, Config config, boolean structured, boolean failSilently) {
        String string;
        block11: {
            EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
            Closeable ignored = LockChecker.checkDatabaseLock((DatabaseLayout)databaseLayout);
            try {
                StorageEngineFactory storageEngineFactory = (StorageEngineFactory)this.storageEngineSelector.selectStorageEngine(fs, databaseLayout, pageCache).orElseThrow();
                StoreVersionCheck storeVersionCheck = storageEngineFactory.versionCheck(fs, databaseLayout, Config.defaults(), pageCache, (LogService)NullLogService.getInstance(), PageCacheTracer.NULL);
                String storeVersion = (String)storeVersionCheck.storeVersion(CursorContext.NULL).orElseThrow(() -> new CommandFailedException(String.format("Could not find version metadata in store '%s'", databaseLayout.databaseDirectory())));
                StoreVersion versionInformation = storageEngineFactory.versionInformation(storeVersion);
                boolean recoveryRequired = StoreInfoCommand.checkRecoveryState(fs, pageCache, databaseLayout, config, (MemoryTracker)memoryTracker, storageEngineFactory);
                TransactionIdStore txIdStore = storageEngineFactory.readOnlyTransactionIdStore(fs, databaseLayout, pageCache, CursorContext.NULL);
                long lastTxId = txIdStore.getLastCommittedTransactionId();
                String successorString = versionInformation.successorStoreVersion().map(successor -> storageEngineFactory.versionInformation(successor).introductionNeo4jVersion()).orElse(null);
                StoreInfo storeInfo = StoreInfo.notInUseResult(databaseLayout.getDatabaseName(), storeVersion, versionInformation.introductionNeo4jVersion(), successorString, lastTxId, recoveryRequired);
                string = storeInfo.print(structured);
                if (ignored == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileLockException e) {
                    if (!failSilently) {
                        throw new CommandFailedException(String.format("Failed to execute command as the database '%s' is in use. Please stop it and try again.", databaseLayout.getDatabaseName()), (Throwable)e);
                    }
                    return StoreInfo.inUseResult(databaseLayout.getDatabaseName()).print(structured);
                }
                catch (CommandFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CommandFailedException(String.format("Failed to execute command: '%s'.", e.getMessage()), (Throwable)e);
                }
            }
            ignored.close();
        }
        return string;
    }

    private static boolean checkRecoveryState(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker, StorageEngineFactory storageEngineFactory) {
        try {
            return Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (PageCache)pageCache, (DatabaseLayout)databaseLayout, (StorageEngineFactory)storageEngineFactory, (Config)config, Optional.empty(), (MemoryTracker)memoryTracker);
        }
        catch (Exception e) {
            throw new CommandFailedException(String.format("Failed to execute command when checking for recovery state: '%s'.", e.getMessage()), (Throwable)e);
        }
    }

    private static enum InfoType {
        InUse("Database in use", "inUse"),
        DatabaseName("Database name", "databaseName"),
        StoreFormat("Store format version", "storeFormat"),
        StoreFormatIntroduced("Store format introduced in", "storeFormatIntroduced"),
        StoreFormatSuperseded("Store format superseded in", "storeFormatSuperseded"),
        LastCommittedTransaction("Last committed transaction id", "lastCommittedTransaction"),
        RecoveryRequired("Store needs recovery", "recoveryRequired");

        private final String prettyPrint;
        private final String jsonKey;

        private InfoType(String prettyPrint, String jsonKey) {
            this.prettyPrint = prettyPrint;
            this.jsonKey = jsonKey;
        }

        String justifiedPretty(String value) {
            String nullSafeValue = value == null ? "N/A" : value;
            String leftJustifiedFmt = "%-30s%s";
            return String.format(leftJustifiedFmt, this.prettyPrint + ":", nullSafeValue);
        }

        String structuredJson(String value) {
            String kFmt = "\"%s\":";
            String kvFmt = kFmt + "\"%s\"";
            return value == null ? String.format(kFmt + "null", this.jsonKey) : String.format(kvFmt, this.jsonKey, value);
        }
    }

    private static class StoreInfo {
        private final String databaseName;
        private final String storeFormat;
        private final String storeFormatIntroduced;
        private final String storeFormatSuperseded;
        private final long lastCommittedTransaction;
        private final boolean recoveryRequired;
        private final boolean inUse;

        static StoreInfo inUseResult(String databaseName) {
            return new StoreInfo(databaseName, true, null, null, null, -1L, true);
        }

        static StoreInfo notInUseResult(String databaseName, String storeFormat, String storeFormatIntroduced, String storeFormatSuperseded, long lastCommittedTransaction, boolean recoveryRequired) {
            return new StoreInfo(databaseName, false, storeFormat, storeFormatIntroduced, storeFormatSuperseded, lastCommittedTransaction, recoveryRequired);
        }

        private StoreInfo(String databaseName, boolean inUse, String storeFormat, String storeFormatIntroduced, String storeFormatSuperseded, long lastCommittedTransaction, boolean recoveryRequired) {
            this.databaseName = databaseName;
            this.storeFormat = storeFormat;
            this.storeFormatIntroduced = storeFormatIntroduced;
            this.storeFormatSuperseded = storeFormatSuperseded;
            this.lastCommittedTransaction = lastCommittedTransaction;
            this.recoveryRequired = recoveryRequired;
            this.inUse = inUse;
        }

        List<Pair<InfoType, String>> printFields() {
            return List.of(Pair.of((Object)((Object)InfoType.DatabaseName), (Object)this.databaseName), Pair.of((Object)((Object)InfoType.InUse), (Object)Boolean.toString(this.inUse)), Pair.of((Object)((Object)InfoType.StoreFormat), (Object)this.storeFormat), Pair.of((Object)((Object)InfoType.StoreFormatIntroduced), (Object)this.storeFormatIntroduced), Pair.of((Object)((Object)InfoType.StoreFormatSuperseded), (Object)this.storeFormatSuperseded), Pair.of((Object)((Object)InfoType.LastCommittedTransaction), (Object)Long.toString(this.lastCommittedTransaction)), Pair.of((Object)((Object)InfoType.RecoveryRequired), (Object)Boolean.toString(this.recoveryRequired)));
        }

        String print(boolean structured) {
            if (!structured) {
                return this.printFields().stream().filter(p -> Objects.nonNull(p.other())).map(p -> ((InfoType)((Object)((Object)p.first()))).justifiedPretty((String)p.other())).collect(Collectors.joining(System.lineSeparator()));
            }
            return this.printFields().stream().map(p -> ((InfoType)((Object)((Object)p.first()))).structuredJson((String)p.other())).collect(Collectors.joining(",", "{", "}"));
        }
    }
}

