/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.neo4j.bolt.packstream.PackInput;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackStream;
import org.neo4j.bolt.packstream.PackedInputArray;
import org.neo4j.fabric.bolt.FabricBookmark;
import org.neo4j.fabric.bookmark.PackedOutputArray;
import org.neo4j.fabric.bookmark.RemoteBookmark;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.kernel.api.exceptions.Status;

public class BookmarkStateSerializer {
    public static String serialize(FabricBookmark fabricBookmark) {
        try {
            Packer packer = new Packer(fabricBookmark);
            String p = packer.pack();
            return p;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to serialize bookmark", exception);
        }
    }

    public static FabricBookmark deserialize(String serializedBookmark) {
        try {
            Unpacker unpacker = new Unpacker(serializedBookmark);
            return unpacker.unpack();
        }
        catch (IOException exception) {
            throw new FabricException((Status)Status.Transaction.InvalidBookmark, "Failed to deserialize bookmark", exception);
        }
    }

    private static class BookmarkPackStreamPacker
    extends PackStream.Packer {
        BookmarkPackStreamPacker(PackOutput out) {
            super(out, input -> ByteBuffer.wrap(input.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static class Unpacker {
        final PackStream.Unpacker unpacker;

        Unpacker(String serializedBookmark) {
            byte[] bytes = Base64.getDecoder().decode(serializedBookmark);
            PackedInputArray packedInputArray = new PackedInputArray(bytes);
            this.unpacker = new PackStream.Unpacker((PackInput)packedInputArray);
        }

        FabricBookmark unpack() throws IOException {
            List<FabricBookmark.InternalGraphState> internalGraphs = this.unpackInternalGraphs();
            List<FabricBookmark.ExternalGraphState> externalGraphs = this.unpackExternalGraphs();
            return new FabricBookmark(internalGraphs, externalGraphs);
        }

        List<FabricBookmark.InternalGraphState> unpackInternalGraphs() throws IOException {
            int listSize = (int)this.unpacker.unpackListHeader();
            ArrayList<FabricBookmark.InternalGraphState> internalGraphs = new ArrayList<FabricBookmark.InternalGraphState>(listSize);
            for (int i = 0; i < listSize; ++i) {
                FabricBookmark.InternalGraphState internalGraphState = this.unpackInternalGraph();
                internalGraphs.add(internalGraphState);
            }
            return internalGraphs;
        }

        FabricBookmark.InternalGraphState unpackInternalGraph() throws IOException {
            UUID graphUuid = this.unpackUuid();
            long txId = this.unpacker.unpackLong();
            return new FabricBookmark.InternalGraphState(graphUuid, txId);
        }

        List<FabricBookmark.ExternalGraphState> unpackExternalGraphs() throws IOException {
            int listSize = (int)this.unpacker.unpackListHeader();
            ArrayList<FabricBookmark.ExternalGraphState> externalGraphs = new ArrayList<FabricBookmark.ExternalGraphState>(listSize);
            for (int i = 0; i < listSize; ++i) {
                FabricBookmark.ExternalGraphState externalGraphState = this.unpackExternalGraph();
                externalGraphs.add(externalGraphState);
            }
            return externalGraphs;
        }

        FabricBookmark.ExternalGraphState unpackExternalGraph() throws IOException {
            UUID graphUuid = this.unpackUuid();
            int listSize = (int)this.unpacker.unpackListHeader();
            ArrayList<RemoteBookmark> remoteBookmarks = new ArrayList<RemoteBookmark>(listSize);
            for (int i = 0; i < listSize; ++i) {
                String serializedRemoteBookmark = this.unpacker.unpackString();
                remoteBookmarks.add(new RemoteBookmark(serializedRemoteBookmark));
            }
            return new FabricBookmark.ExternalGraphState(graphUuid, remoteBookmarks);
        }

        UUID unpackUuid() throws IOException {
            byte[] uuidBytes = this.unpacker.unpackBytes();
            ByteBuffer byteBuffer = ByteBuffer.wrap(uuidBytes);
            long high = byteBuffer.getLong();
            long low = byteBuffer.getLong();
            return new UUID(high, low);
        }
    }

    private static class Packer {
        final PackedOutputArray packedOutputArray = new PackedOutputArray();
        final PackStream.Packer packer = new BookmarkPackStreamPacker(this.packedOutputArray);
        final FabricBookmark fabricBookmark;

        Packer(FabricBookmark fabricBookmark) {
            this.fabricBookmark = fabricBookmark;
        }

        String pack() throws IOException {
            this.packInternalGraphs(this.fabricBookmark.getInternalGraphStates());
            this.packExternalGraphs(this.fabricBookmark.getExternalGraphStates());
            this.packer.flush();
            return Base64.getEncoder().encodeToString(this.packedOutputArray.bytes());
        }

        void packInternalGraphs(List<FabricBookmark.InternalGraphState> internalGraphStates) throws IOException {
            this.packer.packListHeader(internalGraphStates.size());
            for (FabricBookmark.InternalGraphState internalGraphState : internalGraphStates) {
                this.packInternalGraph(internalGraphState);
            }
        }

        void packInternalGraph(FabricBookmark.InternalGraphState internalGraphState) throws IOException {
            this.packUuid(internalGraphState.getGraphUuid());
            this.packer.pack(internalGraphState.getTransactionId());
        }

        void packExternalGraphs(List<FabricBookmark.ExternalGraphState> externalGraphStates) throws IOException {
            this.packer.packListHeader(externalGraphStates.size());
            for (FabricBookmark.ExternalGraphState externalGraphState : externalGraphStates) {
                this.packExternalGraph(externalGraphState);
            }
        }

        void packExternalGraph(FabricBookmark.ExternalGraphState externalGraphState) throws IOException {
            this.packUuid(externalGraphState.getGraphUuid());
            this.packer.packListHeader(externalGraphState.getBookmarks().size());
            for (RemoteBookmark remoteBookmark : externalGraphState.getBookmarks()) {
                this.packer.pack(remoteBookmark.getSerialisedState());
            }
        }

        void packUuid(UUID uuid) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.putLong(uuid.getMostSignificantBits());
            buffer.putLong(uuid.getLeastSignificantBits());
            this.packer.pack(buffer.array());
        }
    }
}

