/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.storageengine.api.RecoveryState;

public class StorageFilesState {
    private final RecoveryState recoveryState;
    private final Collection<Path> missingFiles;

    private StorageFilesState(RecoveryState recoveryState, Collection<Path> missingFiles) {
        this.recoveryState = recoveryState;
        this.missingFiles = missingFiles;
    }

    public RecoveryState getRecoveryState() {
        return this.recoveryState;
    }

    public Collection<Path> getMissingFiles() {
        return this.missingFiles;
    }

    public static StorageFilesState recoverableState() {
        return new StorageFilesState(RecoveryState.RECOVERABLE, Collections.emptyList());
    }

    public static StorageFilesState recoveredState() {
        return new StorageFilesState(RecoveryState.RECOVERED, Collections.emptyList());
    }

    public static StorageFilesState unrecoverableState(Collection<Path> missingFiles) {
        return new StorageFilesState(RecoveryState.UNRECOVERABLE, missingFiles);
    }
}

