/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms;

import java.util.Optional;
import org.neo4j.dbms.DatabaseState;
import org.neo4j.dbms.DefaultOperatorState;
import org.neo4j.dbms.OperatorState;
import org.neo4j.kernel.database.NamedDatabaseId;

public final class CommunityDatabaseState
implements DatabaseState {
    private final NamedDatabaseId namedDatabaseId;
    private final boolean unknown;
    private final boolean isStarted;
    private final boolean hasFailed;
    private final Throwable failureCause;

    public CommunityDatabaseState(NamedDatabaseId namedDatabaseId, boolean isStarted, boolean hasFailed, Throwable failureCause) {
        this(namedDatabaseId, isStarted, hasFailed, false, failureCause);
    }

    private CommunityDatabaseState(NamedDatabaseId namedDatabaseId, boolean isStarted, boolean hasFailed, boolean unknown, Throwable failureCause) {
        this.namedDatabaseId = namedDatabaseId;
        this.isStarted = isStarted;
        this.hasFailed = hasFailed;
        this.failureCause = failureCause;
        this.unknown = unknown;
    }

    public static CommunityDatabaseState unknown(NamedDatabaseId namedDatabaseId) {
        return new CommunityDatabaseState(namedDatabaseId, false, false, true, null);
    }

    public NamedDatabaseId databaseId() {
        return this.namedDatabaseId;
    }

    public OperatorState operatorState() {
        return this.unknown ? DefaultOperatorState.UNKNOWN : (this.isStarted ? DefaultOperatorState.STARTED : DefaultOperatorState.STOPPED);
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public Optional<Throwable> failure() {
        return Optional.ofNullable(this.failureCause);
    }
}

