/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UpdateCountingIndexUpdater;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class OnlineIndexProxy
implements IndexProxy {
    private final IndexProxyStrategy indexProxyStrategy;
    final IndexAccessor accessor;
    private boolean started;
    private final boolean forcedIdempotentMode;

    OnlineIndexProxy(IndexProxyStrategy indexProxyStrategy, IndexAccessor accessor, boolean forcedIdempotentMode) {
        assert (accessor != null);
        this.indexProxyStrategy = indexProxyStrategy;
        this.accessor = accessor;
        this.forcedIdempotentMode = forcedIdempotentMode;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
        IndexUpdater actual = this.accessor.newUpdater(this.escalateModeIfNecessary(mode), cursorContext);
        return this.started ? this.updateCountingUpdater(actual) : actual;
    }

    private IndexUpdateMode escalateModeIfNecessary(IndexUpdateMode mode) {
        if (this.forcedIdempotentMode) {
            if (mode != IndexUpdateMode.ONLINE) {
                throw new IllegalArgumentException("Unexpected mode " + String.valueOf(mode) + " given that " + String.valueOf(this) + " has been marked with forced idempotent mode. Expected mode " + String.valueOf(IndexUpdateMode.ONLINE));
            }
            return IndexUpdateMode.ONLINE_IDEMPOTENT;
        }
        return mode;
    }

    private IndexUpdater updateCountingUpdater(IndexUpdater indexUpdater) {
        return new UpdateCountingIndexUpdater(this.indexProxyStrategy, indexUpdater);
    }

    public void drop() {
        this.indexProxyStrategy.removeStatisticsForIndex();
        this.accessor.drop();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.indexProxyStrategy.getIndexDescriptor();
    }

    @Override
    public void changeIdentity(IndexDescriptor descriptor) {
        this.indexProxyStrategy.changeIndexDescriptor(descriptor);
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force(CursorContext cursorContext) {
        this.accessor.force(cursorContext);
    }

    @Override
    public void refresh() {
        this.accessor.refresh();
    }

    @Override
    public void close(CursorContext cursorContext) throws IOException {
        this.accessor.close();
    }

    @Override
    public ValueIndexReader newValueReader() {
        return this.accessor.newValueReader();
    }

    @Override
    public TokenIndexReader newTokenReader() {
        return this.accessor.newTokenReader();
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
        this.accessor.validateBeforeCommit(entityId, tuple);
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(String.valueOf(this) + " is ONLINE");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.DONE;
    }

    @Override
    public ResourceIterator<Path> snapshotFiles() {
        return this.accessor.snapshotFiles();
    }

    public Map<String, Value> indexConfig() {
        return this.accessor.indexConfig();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + String.valueOf(this.accessor) + ", descriptor:" + String.valueOf(this.indexProxyStrategy.getIndexDescriptor()) + "]";
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        this.accessor.verifyDeferredConstraints(nodePropertyAccessor);
    }

    @VisibleForTesting
    public IndexAccessor accessor() {
        return this.accessor;
    }
}

