/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class PopulatingIndexProxy
implements IndexProxy {
    private final IndexProxyStrategy indexProxyStrategy;
    private final IndexPopulationJob job;
    private final MultipleIndexPopulator.IndexPopulation indexPopulation;

    PopulatingIndexProxy(IndexProxyStrategy indexProxyStrategy, IndexPopulationJob job, MultipleIndexPopulator.IndexPopulation indexPopulation) {
        this.indexProxyStrategy = indexProxyStrategy;
        this.job = job;
        this.indexPopulation = indexPopulation;
    }

    @Override
    public void start() {
    }

    @Override
    public void changeIdentity(IndexDescriptor descriptor) {
        this.indexProxyStrategy.changeIndexDescriptor(descriptor);
    }

    @Override
    public IndexUpdater newUpdater(final IndexUpdateMode mode, CursorContext cursorContext) {
        switch (mode) {
            case ONLINE: 
            case RECOVERY: {
                return new PopulatingIndexUpdater(){

                    public void process(IndexEntryUpdate<?> update) {
                        PopulatingIndexProxy.this.job.update(update);
                    }
                };
            }
        }
        return new PopulatingIndexUpdater(){

            public void process(IndexEntryUpdate<?> update) {
                throw new IllegalArgumentException("Unsupported update mode: " + String.valueOf(mode));
            }
        };
    }

    public void drop() {
        this.job.dropPopulation(this.indexPopulation);
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.indexProxyStrategy.getIndexDescriptor();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public void force(CursorContext cursorContext) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close(CursorContext cursorContext) {
        this.job.stop(this.indexPopulation, cursorContext);
    }

    @Override
    public ValueIndexReader newValueReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + String.valueOf(this.job));
    }

    @Override
    public TokenIndexReader newTokenReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + String.valueOf(this.job));
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) throws InterruptedException {
        return this.job.awaitCompletion(time, unit);
    }

    @Override
    public void activate() {
        throw new IllegalStateException("Cannot activate index while it is still populating: " + String.valueOf(this.job));
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating: " + String.valueOf(this.job));
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
    }

    @Override
    public ResourceIterator<Path> snapshotFiles() {
        return Iterators.emptyResourceIterator();
    }

    public Map<String, Value> indexConfig() {
        return this.indexPopulation.populator.indexConfig();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(String.valueOf(this) + " is POPULATING");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.job.getPopulationProgress(this.indexPopulation);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + String.valueOf(this.job) + "]";
    }

    private static abstract class PopulatingIndexUpdater
    implements IndexUpdater {
        private PopulatingIndexUpdater() {
        }

        public void close() {
        }
    }
}

