/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.tracer;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;

class CountingLogRotateEvent
implements LogRotateEvent {
    private final AtomicLong rotationCounter = new AtomicLong();
    private final AtomicLong accumulatedRotationTimeMillis = new AtomicLong();
    private volatile long lastRotationTimeMillis;

    CountingLogRotateEvent() {
    }

    @Override
    public void rotationCompleted(long rotationMillis) {
        this.rotationCounter.incrementAndGet();
        this.accumulatedRotationTimeMillis.addAndGet(rotationMillis);
        this.lastRotationTimeMillis = rotationMillis;
    }

    @Override
    public void close() {
    }

    long numberOfLogRotations() {
        return this.rotationCounter.get();
    }

    long logRotationAccumulatedTotalTimeMillis() {
        return this.accumulatedRotationTimeMillis.get();
    }

    long lastLogRotationTimeMillis() {
        return this.lastRotationTimeMillis;
    }
}

