/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public class PathProxy
implements Path {
    private final long[] nodes;
    private final long[] relationships;
    private final int[] directedTypes;
    private final InternalTransaction internalTransaction;

    public PathProxy(InternalTransaction internalTransaction, long[] nodes, long[] relationships, int[] directedTypes) {
        this.internalTransaction = internalTransaction;
        assert (nodes.length == relationships.length + 1);
        assert (relationships.length == directedTypes.length);
        this.nodes = nodes;
        this.relationships = relationships;
        this.directedTypes = directedTypes;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('(').append(this.nodes[0]).append(')');
        boolean inTx = true;
        for (int i = 0; i < this.relationships.length; ++i) {
            int type = this.directedTypes[i];
            string.append(type < 0 ? "<-[" : "-[");
            string.append(this.relationships[i]);
            if (inTx) {
                try {
                    String name = this.internalTransaction.getRelationshipTypeById(type < 0 ? ~type : type).name();
                    string.append(':').append(name);
                }
                catch (Exception e) {
                    inTx = false;
                }
            }
            string.append(type < 0 ? "]-(" : "]->(").append(this.nodes[i + 1]).append(')');
        }
        return string.toString();
    }

    public int hashCode() {
        if (this.relationships.length == 0) {
            return Long.hashCode(this.nodes[0]);
        }
        return Arrays.hashCode(this.relationships);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathProxy) {
            PathProxy that = (PathProxy)obj;
            return Arrays.equals(this.nodes, that.nodes) && Arrays.equals(this.relationships, that.relationships);
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (this.nodes[0] != other.startNode().getId()) {
                return false;
            }
            return Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
        }
        return false;
    }

    public Node startNode() {
        return new NodeEntity(this.internalTransaction, this.nodes[0]);
    }

    public Node endNode() {
        return new NodeEntity(this.internalTransaction, this.nodes[this.nodes.length - 1]);
    }

    public Relationship lastRelationship() {
        return this.relationships.length == 0 ? null : this.relationship(this.relationships.length - 1);
    }

    private RelationshipEntity relationship(int offset) {
        int type = this.directedTypes[offset];
        if (type >= 0) {
            return new RelationshipEntity(this.internalTransaction, this.relationships[offset], this.nodes[offset], type, this.nodes[offset + 1]);
        }
        return new RelationshipEntity(this.internalTransaction, this.relationships[offset], this.nodes[offset + 1], ~type, this.nodes[offset]);
    }

    public Iterable<Relationship> relationships() {
        return () -> new Iterator<Relationship>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < PathProxy.this.relationships.length;
            }

            @Override
            public Relationship next() {
                return PathProxy.this.relationship(this.i++);
            }
        };
    }

    public Iterable<Relationship> reverseRelationships() {
        return () -> new Iterator<Relationship>(){
            int i;
            {
                this.i = PathProxy.this.relationships.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public Relationship next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PathProxy.this.relationship(--this.i);
            }
        };
    }

    public Iterable<Node> nodes() {
        return () -> new Iterator<Node>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < PathProxy.this.nodes.length;
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new NodeEntity(PathProxy.this.internalTransaction, PathProxy.this.nodes[this.i++]);
            }
        };
    }

    public Iterable<Node> reverseNodes() {
        return () -> new Iterator<Node>(){
            int i;
            {
                this.i = PathProxy.this.nodes.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new NodeEntity(PathProxy.this.internalTransaction, PathProxy.this.nodes[--this.i]);
            }
        };
    }

    public int length() {
        return this.relationships.length;
    }

    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            int i;
            boolean relationship;

            @Override
            public boolean hasNext() {
                return this.i < PathProxy.this.relationships.length || !this.relationship;
            }

            @Override
            public Entity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.relationship) {
                    this.relationship = false;
                    return PathProxy.this.relationship(this.i++);
                }
                this.relationship = true;
                return new NodeEntity(PathProxy.this.internalTransaction, PathProxy.this.nodes[this.i]);
            }
        };
    }
}

