/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.Value;

class FusionIndexReader
extends FusionIndexBase<ValueIndexReader>
implements ValueIndexReader {
    private final IndexDescriptor descriptor;

    FusionIndexReader(SlotSelector slotSelector, LazyInstanceSelector<ValueIndexReader> instanceSelector, IndexDescriptor descriptor) {
        super(slotSelector, instanceSelector);
        this.descriptor = descriptor;
    }

    public void close() {
        this.instanceSelector.close(Resource::close);
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        ValueIndexReader indexReader = (ValueIndexReader)this.instanceSelector.select(this.slotSelector.selectSlot(propertyValues, CATEGORY_OF));
        return indexReader.countIndexedEntities(entityId, cursorContext, propertyKeyIds, propertyValues);
    }

    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.instanceSelector.transform(ValueIndexReader::createSampler));
    }

    public void query(IndexProgressor.EntityValueClient cursor, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexSlot slot = this.slotSelector.selectSlot(predicates, PropertyIndexQuery::valueCategory);
        if (slot != null) {
            ((ValueIndexReader)this.instanceSelector.select(slot)).query(cursor, context, accessMode, constraints, predicates);
        } else {
            if (constraints.isOrdered()) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", constraints.order(), Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, (IndexProgressor)multiProgressor, accessMode, false, constraints, predicates);
            try {
                this.instanceSelector.forAll(reader -> {
                    try {
                        reader.query((IndexProgressor.EntityValueClient)multiProgressor, context, accessMode, constraints, predicates);
                    }
                    catch (IndexNotApplicableKernelException e) {
                        throw new InnerException(e);
                    }
                });
            }
            catch (InnerException e) {
                throw e.getCause();
            }
        }
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        IndexSlot slot = this.slotSelector.selectSlot(query, PropertyIndexQuery::valueCategory);
        if (slot == null) {
            throw new UnsupportedOperationException();
        }
        return ((ValueIndexReader)this.instanceSelector.select(slot)).valueSeek(desiredNumberOfPartitions, context, query);
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super(e);
        }

        @Override
        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

