/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class SchemaAndIndexingFileIndexListing {
    private static final Function<Path, StoreFileMetadata> toStoreFileMetadata = path -> new StoreFileMetadata(path, 1);
    private final IndexingService indexingService;

    SchemaAndIndexingFileIndexListing(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public LongSet getIndexIds() {
        return this.indexingService.getIndexIds();
    }

    Resource gatherSchemaIndexFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<Path> snapshot = this.indexingService.snapshotIndexFiles();
        SchemaAndIndexingFileIndexListing.getSnapshotFilesMetadata(snapshot, targetFiles);
        return snapshot;
    }

    private static void getSnapshotFilesMetadata(ResourceIterator<Path> snapshot, Collection<StoreFileMetadata> targetFiles) {
        snapshot.stream().map(toStoreFileMetadata).forEach(targetFiles::add);
    }
}

