/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesSpan;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionLogInitializer {
    private static final String LOGS_UPGRADER_TRACER_TAG = "LogsUpgrader";
    private static final String RESET_TRANSACTION_OFFSET_TAG = "ResetTransactionOffset";
    private final FileSystemAbstraction fs;
    private final MetadataProvider store;
    private final StorageEngineFactory storageEngineFactory;
    private final PageCacheTracer tracer;

    public static LogFilesInitializer getLogFilesInitializer() {
        return (databaseLayout, store, fileSystem, checkpointReason) -> {
            try {
                TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, store, StorageEngineFactory.defaultStorageEngine(), PageCacheTracer.NULL);
                initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Fail to create empty transaction log file.", (Throwable)e);
            }
        };
    }

    public TransactionLogInitializer(FileSystemAbstraction fs, MetadataProvider store, StorageEngineFactory storageEngineFactory, PageCacheTracer tracer) {
        this.fs = fs;
        this.store = store;
        this.storageEngineFactory = storageEngineFactory;
        this.tracer = tracer;
    }

    public void initializeEmptyLogFile(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason) throws IOException {
        try (CursorContext cursorContext = new CursorContext(this.tracer.createPageCursorTracer(RESET_TRANSACTION_OFFSET_TAG));){
            this.store.resetLastClosedTransaction(this.store.getLastCommittedTransactionId(), this.store.getLastClosedTransactionId(), 64L, true, cursorContext);
        }
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
        }
    }

    public void initializeExistingLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason) throws Exception {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            LogFile logFile = logFiles.getLogFile();
            LogHeader logHeader = logFile.extractHeader(logFile.getLowestLogVersion());
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory(), false);
            try (ReadableLogChannel readableChannel = logFile.getReader(logHeader.getStartPosition());
                 LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)entryReader, (ReadableClosablePositionAwareChecksumChannel)readableChannel);){
                while (true) {
                    if (cursor.next()) {
                        LogEntry entry = cursor.get();
                        if (entry.getType() != 5) continue;
                        TransactionLogInitializer.appendCheckpoint(logFiles, checkpointReason, logFile.getTransactionLogWriter().getCurrentPosition());
                        return;
                        continue;
                    }
                    break;
                }
            }
            this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
        }
    }

    private LogFilesSpan buildLogFiles(DatabaseLayout layout, Path transactionLogsDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder(layout, this.fs).withLogVersionRepository((LogVersionRepository)this.store).withTransactionIdStore((TransactionIdStore)this.store).withStoreId(this.store.getStoreId()).withLogsDirectory(transactionLogsDirectory).withStorageEngineFactory(this.storageEngineFactory).withDatabaseHealth(new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance())).build();
        return new LogFilesSpan(new Lifespan(new Lifecycle[]{logFiles}), logFiles);
    }

    private void appendEmptyTransactionAndCheckPoint(LogFiles logFiles, String reason) throws IOException {
        long timestamp = this.store.getLastCommittedTransaction().commitTimestamp();
        long transactionId = this.store.nextCommittingTransactionId();
        LogFile logFile = logFiles.getLogFile();
        TransactionLogWriter transactionLogWriter = logFile.getTransactionLogWriter();
        PhysicalTransactionRepresentation emptyTx = TransactionLogInitializer.emptyTransaction(timestamp);
        int checksum = transactionLogWriter.append(emptyTx, transactionId, -559063315);
        logFile.forceAfterAppend(LogAppendEvent.NULL);
        LogPosition position = transactionLogWriter.getCurrentPosition();
        TransactionLogInitializer.appendCheckpoint(logFiles, reason, position);
        try (CursorContext cursorContext = new CursorContext(this.tracer.createPageCursorTracer(LOGS_UPGRADER_TRACER_TAG));){
            this.store.setLastCommittedAndClosedTransactionId(transactionId, checksum, timestamp, position.getByteOffset(), position.getLogVersion(), cursorContext);
        }
    }

    private static PhysicalTransactionRepresentation emptyTransaction(long timestamp) {
        return new PhysicalTransactionRepresentation(Collections.emptyList(), ArrayUtils.EMPTY_BYTE_ARRAY, timestamp, 1L, timestamp, -1, AuthSubject.ANONYMOUS);
    }

    private static void appendCheckpoint(LogFiles logFiles, String reason, LogPosition position) throws IOException {
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, position, Instant.now(), reason);
    }
}

