/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.internal.locker.FileLockException;

public class Locker
implements Closeable {
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Path lockFile;
    FileLock lockFileLock;
    private StoreChannel lockFileChannel;

    public Locker(FileSystemAbstraction fileSystemAbstraction, Path lockFile) {
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.lockFile = lockFile;
    }

    public final Path lockFile() {
        return this.lockFile;
    }

    public void checkLock() {
        if (this.haveLockAlready()) {
            return;
        }
        try {
            if (!this.fileSystemAbstraction.fileExists(this.lockFile)) {
                this.fileSystemAbstraction.mkdirs(this.lockFile.getParent());
            }
        }
        catch (IOException e) {
            String message = "Unable to create path for dir: " + String.valueOf(this.lockFile.getParent());
            throw Locker.storeLockException(message, e);
        }
        try {
            if (this.lockFileChannel == null) {
                this.lockFileChannel = this.fileSystemAbstraction.write(this.lockFile);
            }
            this.lockFileLock = this.lockFileChannel.tryLock();
            if (this.lockFileLock == null) {
                String message = "Lock file has been locked by another process: " + String.valueOf(this.lockFile);
                throw Locker.storeLockException(message, null);
            }
        }
        catch (OverlappingFileLockException e) {
            throw this.unableToObtainLockException();
        }
        catch (IOException e) {
            throw this.unableToObtainLockException(this.tryCollectPermissionInformation(), e);
        }
    }

    private String tryCollectPermissionInformation() {
        String processUserName = System.getProperty("user.name");
        String additionalInformation = null;
        if (processUserName != null) {
            Path lockPath = this.lockFile;
            try {
                String lockFileOwner = Files.getOwner(lockPath, new LinkOption[0]).getName();
                if (!processUserName.equals(lockFileOwner)) {
                    additionalInformation = String.format("Owner of the lock file '%s' and user running this process '%s' differs, which means this could be a file permission problem. Ensure that the lock file has the same owner, or at least has write access for the user running the Neo4j process trying to lock it", lockFileOwner, processUserName);
                }
            }
            catch (IOException fe) {
                try {
                    String lockDirectoryOwner = Files.getOwner(lockPath.getParent(), new LinkOption[0]).getName();
                    if (!processUserName.equals(lockDirectoryOwner)) {
                        additionalInformation = String.format("Owner of the directory of the lock file '%s' and user running this process '%s' differs, which means this could be a file permission problem. Ensure that the lock file directory (and lock file it it exists) has the same owner, or at least has write access for the user running the Neo4j process trying to lock it", lockDirectoryOwner, processUserName);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return additionalInformation;
    }

    protected boolean haveLockAlready() {
        return this.lockFileLock != null && this.lockFileChannel != null;
    }

    FileLockException unableToObtainLockException() {
        return this.unableToObtainLockException(null, null);
    }

    FileLockException unableToObtainLockException(String additionalInformation, Exception cause) {
        String message = String.format("Unable to obtain lock on file: %s%s", this.lockFile, additionalInformation != null ? ": " + additionalInformation : "");
        return Locker.storeLockException(message, cause);
    }

    private static FileLockException storeLockException(String message, Exception e) {
        String help = "Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)";
        return new FileLockException(message + ". " + help, e);
    }

    @Override
    public void close() throws IOException {
        if (this.lockFileLock != null) {
            this.releaseLock();
        }
        if (this.lockFileChannel != null) {
            this.releaseChannel();
        }
    }

    private void releaseChannel() throws IOException {
        this.lockFileChannel.close();
        this.lockFileChannel = null;
    }

    protected void releaseLock() throws IOException {
        this.lockFileLock.release();
        this.lockFileLock = null;
    }
}

