/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.logging.ChannelErrorLogger;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.util.ErrorUtil;

public class HandshakeHandler
extends ReplayingDecoder<Void> {
    private final ChannelPipelineBuilder pipelineBuilder;
    private final ChannelPromise handshakeCompletedPromise;
    private final Logging logging;
    private boolean failed;
    private ChannelActivityLogger log;
    private ChannelErrorLogger errorLog;

    public HandshakeHandler(ChannelPipelineBuilder pipelineBuilder, ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedPromise = handshakeCompletedPromise;
        this.logging = logging;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
        this.errorLog = new ChannelErrorLogger(ctx.channel(), this.logging);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.failed = false;
        this.log = null;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.debug("Channel is inactive", new Object[0]);
        if (!this.failed) {
            ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError();
            this.fail(ctx, error);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.errorLog.traceOrDebug("Another fatal error occurred in the pipeline", error);
        } else {
            this.failed = true;
            Throwable cause = HandshakeHandler.transformError(error);
            this.fail(ctx, cause);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        BoltProtocolVersion serverSuggestedVersion = BoltProtocolVersion.fromRawBytes(in.readInt());
        this.log.debug("S: [Bolt Handshake] %s", serverSuggestedVersion);
        ctx.pipeline().remove(this);
        BoltProtocol protocol = this.protocolForVersion(serverSuggestedVersion);
        if (protocol != null) {
            this.protocolSelected(serverSuggestedVersion, protocol.createMessageFormat(), ctx);
        } else {
            this.handleUnknownSuggestedProtocolVersion(serverSuggestedVersion, ctx);
        }
    }

    private BoltProtocol protocolForVersion(BoltProtocolVersion version) {
        try {
            return BoltProtocol.forVersion(version);
        }
        catch (ClientException e) {
            return null;
        }
    }

    private void protocolSelected(BoltProtocolVersion version, MessageFormat messageFormat, ChannelHandlerContext ctx) {
        ChannelAttributes.setProtocolVersion(ctx.channel(), version);
        this.pipelineBuilder.build(messageFormat, ctx.pipeline(), this.logging);
        this.handshakeCompletedPromise.setSuccess();
    }

    private void handleUnknownSuggestedProtocolVersion(BoltProtocolVersion version, ChannelHandlerContext ctx) {
        if (BoltProtocolUtil.NO_PROTOCOL_VERSION.equals(version)) {
            this.fail(ctx, HandshakeHandler.protocolNoSupportedByServerError());
        } else if (BoltProtocolVersion.isHttp(version)) {
            this.fail(ctx, HandshakeHandler.httpEndpointError());
        } else {
            this.fail(ctx, HandshakeHandler.protocolNoSupportedByDriverError(version));
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.handshakeCompletedPromise.tryFailure(error)));
    }

    private static Throwable protocolNoSupportedByServerError() {
        return new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
    }

    private static Throwable httpEndpointError() {
        return new ClientException("Server responded HTTP. Make sure you are not trying to connect to the http endpoint (HTTP defaults to port 7474 whereas BOLT defaults to port 7687)");
    }

    private static Throwable protocolNoSupportedByDriverError(BoltProtocolVersion suggestedProtocolVersion) {
        return new ClientException("Protocol error, server suggested unexpected protocol version: " + suggestedProtocolVersion);
    }

    private static Throwable transformError(Throwable error) {
        if (error instanceof DecoderException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof ServiceUnavailableException) {
            return error;
        }
        if (error instanceof SSLHandshakeException) {
            return new SecurityException("Failed to establish secured connection with the server", error);
        }
        return new ServiceUnavailableException("Failed to establish connection with the server", error);
    }
}

