/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import java.util.Set;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.BoltPatchesListener;
import org.neo4j.driver.internal.messaging.MessageFormat;

public class InboundMessageHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements BoltPatchesListener {
    private final ByteBufInput input = new ByteBufInput();
    private final MessageFormat messageFormat;
    private final Logging logging;
    private InboundMessageDispatcher messageDispatcher;
    private MessageFormat.Reader reader;
    private Logger log;

    public InboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this.messageFormat = messageFormat;
        this.logging = logging;
        this.reader = messageFormat.newReader(this.input);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(channel));
        this.log = new ChannelActivityLogger(channel, this.logging, this.getClass());
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.log = null;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        if (this.messageDispatcher.fatalErrorOccurred()) {
            this.log.warn("Message ignored because of the previous fatal error. Channel will be closed. Message:\n%s", ByteBufUtil.hexDump(msg));
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("S: %s", ByteBufUtil.hexDump(msg));
        }
        this.input.start(msg);
        try {
            this.reader.read(this.messageDispatcher);
        }
        catch (Throwable error) {
            throw new DecoderException("Failed to read inbound message:\n" + ByteBufUtil.hexDump(msg) + "\n", error);
        }
        finally {
            this.input.stop();
        }
    }

    @Override
    public void handle(Set<String> patches) {
        if (patches.contains("utc")) {
            this.messageFormat.enableDateTimeUtc();
            this.reader = this.messageFormat.newReader(this.input);
        }
    }
}

