/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.util.Futures;

public class NettyChannelPool
implements ExtendedChannelPool {
    private static final int MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private static final boolean RELEASE_HEALTH_CHECK = false;
    private final FixedChannelPool delegate;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String id;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();

    NettyChannelPool(final BoltServerAddress address, final ChannelConnector connector, Bootstrap bootstrap, final NettyChannelTracker handler, ChannelHealthChecker healthCheck, long acquireTimeoutMillis, int maxConnections) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(connector);
        Objects.requireNonNull(handler);
        this.id = this.poolId(address);
        this.delegate = new FixedChannelPool(bootstrap, handler, healthCheck, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeoutMillis, maxConnections, Integer.MAX_VALUE, false){

            @Override
            protected ChannelFuture connectChannel(Bootstrap bootstrap) {
                ListenerEvent creatingEvent = handler.channelCreating(NettyChannelPool.this.id);
                ChannelFuture connectedChannelFuture = connector.connect(address, bootstrap);
                Channel channel = connectedChannelFuture.channel();
                ChannelPromise trackedChannelFuture = channel.newPromise();
                connectedChannelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    if (future.isSuccess()) {
                        ChannelAttributes.setPoolId(channel, NettyChannelPool.this.id);
                        handler.channelCreated(channel, creatingEvent);
                        trackedChannelFuture.setSuccess();
                    } else {
                        handler.channelFailedToCreate(NettyChannelPool.this.id);
                        trackedChannelFuture.setFailure(future.cause());
                    }
                }));
                return trackedChannelFuture;
            }
        };
    }

    @Override
    public CompletionStage<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            Futures.asCompletionStage(this.delegate.closeAsync(), this.closeFuture);
        }
        return this.closeFuture;
    }

    @Override
    public CompletionStage<Channel> acquire() {
        return Futures.asCompletionStage(this.delegate.acquire());
    }

    @Override
    public CompletionStage<Void> release(Channel channel) {
        return Futures.asCompletionStage(this.delegate.release(channel));
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public String id() {
        return this.id;
    }

    private String poolId(BoltServerAddress serverAddress) {
        return String.format("%s:%d-%d", serverAddress.host(), serverAddress.port(), this.hashCode());
    }
}

