/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.util.concurrent.Future;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.internal.async.connection.EventLoopGroupFactory;
import org.neo4j.driver.internal.util.ErrorUtil;

public final class Futures {
    private static final CompletableFuture<?> COMPLETED_WITH_NULL = CompletableFuture.completedFuture(null);

    private Futures() {
    }

    public static <T> CompletableFuture<T> completedWithNull() {
        return COMPLETED_WITH_NULL;
    }

    public static <T> CompletableFuture<T> completeWithNullIfNoError(CompletableFuture<T> future, Throwable error) {
        if (error != null) {
            future.completeExceptionally(error);
        } else {
            future.complete(null);
        }
        return future;
    }

    public static <T> CompletionStage<T> asCompletionStage(Future<T> future) {
        CompletableFuture result = new CompletableFuture();
        return Futures.asCompletionStage(future, result);
    }

    public static <T> CompletionStage<T> asCompletionStage(Future<T> future, CompletableFuture<T> result) {
        if (future.isCancelled()) {
            result.cancel(true);
        } else if (future.isSuccess()) {
            result.complete(future.getNow());
        } else if (future.cause() != null) {
            result.completeExceptionally(future.cause());
        } else {
            future.addListener(ignore -> {
                if (future.isCancelled()) {
                    result.cancel(true);
                } else if (future.isSuccess()) {
                    result.complete(future.getNow());
                } else {
                    result.completeExceptionally(future.cause());
                }
            });
        }
        return result;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(error);
        return result;
    }

    public static <V> V blockingGet(CompletionStage<V> stage) {
        return Futures.blockingGet(stage, Futures::noOpInterruptHandler);
    }

    public static <V> V blockingGet(CompletionStage<V> stage, Runnable interruptHandler) {
        EventLoopGroupFactory.assertNotInEventLoopThread();
        CompletableFuture<V> future = stage.toCompletableFuture();
        boolean interrupted = false;
        while (true) {
            try {
                Object v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                Futures.safeRun(interruptHandler);
                continue;
            }
            catch (ExecutionException e) {
                ErrorUtil.rethrowAsyncException(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T getNow(CompletionStage<T> stage) {
        return stage.toCompletableFuture().getNow(null);
    }

    public static <T> T joinNowOrElseThrow(CompletableFuture<T> future, Supplier<? extends RuntimeException> exceptionSupplier) {
        if (future.isDone()) {
            return future.join();
        }
        throw exceptionSupplier.get();
    }

    public static Throwable completionExceptionCause(Throwable error) {
        if (error instanceof CompletionException) {
            return error.getCause();
        }
        return error;
    }

    public static CompletionException asCompletionException(Throwable error) {
        if (error instanceof CompletionException) {
            return (CompletionException)error;
        }
        return new CompletionException(error);
    }

    public static CompletionException combineErrors(Throwable error1, Throwable error2) {
        if (error1 != null && error2 != null) {
            Throwable cause1 = Futures.completionExceptionCause(error1);
            Throwable cause2 = Futures.completionExceptionCause(error2);
            ErrorUtil.addSuppressed(cause1, cause2);
            return Futures.asCompletionException(cause1);
        }
        if (error1 != null) {
            return Futures.asCompletionException(error1);
        }
        if (error2 != null) {
            return Futures.asCompletionException(error2);
        }
        return null;
    }

    public static <T> CompletableFuture<T> onErrorContinue(CompletableFuture<T> future, Throwable errorRecorder, Function<Throwable, ? extends CompletionStage<T>> onErrorAction) {
        Objects.requireNonNull(future);
        return ((CompletableFuture)future.handle((value, error) -> {
            if (error != null) {
                Futures.combineErrors(errorRecorder, error);
                return new CompletionResult<Object>(null, (Throwable)error);
            }
            return new CompletionResult<Object>(value, null);
        })).thenCompose(result -> {
            if (result.value != null) {
                return CompletableFuture.completedFuture(result.value);
            }
            return (CompletionStage)onErrorAction.apply(result.error);
        });
    }

    public static <T> BiConsumer<T, Throwable> futureCompletingConsumer(CompletableFuture<T> future) {
        return (value, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(value);
            }
        };
    }

    private static void safeRun(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void noOpInterruptHandler() {
    }

    private static class CompletionResult<T> {
        T value;
        Throwable error;

        CompletionResult(T value, Throwable error) {
            this.value = value;
            this.error = error;
        }
    }
}

