/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Supplier;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Macro;
import org.jline.reader.Reference;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Attributes;
import org.jline.terminal.TerminalBuilder;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.terminal.CypherJlineParser;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.JlineTerminal;
import org.neo4j.shell.terminal.SimplePrompt;
import org.neo4j.shell.terminal.WriteOnlyCypherShellTerminal;
import org.neo4j.util.VisibleForTesting;

public class CypherShellTerminalBuilder {
    private Logger logger;
    private OutputStream out;
    private InputStream in;
    private boolean isInteractive = true;
    private boolean dumb;
    private Supplier<SimplePrompt> simplePromptSupplier = SimplePrompt::defaultPrompt;

    public CypherShellTerminalBuilder interactive(boolean isInteractive) {
        this.isInteractive = isInteractive;
        return this;
    }

    public CypherShellTerminalBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder dumb() {
        this.dumb = true;
        return this;
    }

    @VisibleForTesting
    public CypherShellTerminalBuilder simplePromptSupplier(Supplier<SimplePrompt> simplePromptSupplier) {
        this.simplePromptSupplier = simplePromptSupplier;
        return this;
    }

    public CypherShellTerminal build() {
        assert (this.logger != null);
        try {
            return this.isInteractive ? this.buildJlineBasedTerminal() : this.nonInteractiveTerminal();
        }
        catch (IOException e) {
            if (this.isInteractive) {
                this.logger.printError("Failed to create interactive terminal, fallback to non-interactive mode");
            }
            return this.nonInteractiveTerminal();
        }
    }

    private CypherShellTerminal nonInteractiveTerminal() {
        return new WriteOnlyCypherShellTerminal(this.out != null ? new PrintStream(this.out) : System.out);
    }

    public CypherShellTerminal buildJlineBasedTerminal() throws IOException {
        TerminalBuilder jLineTerminal = TerminalBuilder.builder();
        jLineTerminal.nativeSignals(true);
        jLineTerminal.paused(true);
        if (this.in != null) {
            jLineTerminal.streams(this.in, this.out);
        }
        if (this.dumb) {
            Attributes attributes = new Attributes();
            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, false);
            jLineTerminal.jna(false).jansi(false);
            jLineTerminal.dumb(true).type("dumb").attributes(attributes);
        }
        LineReader reader = LineReaderBuilder.builder().terminal(jLineTerminal.build()).parser(new CypherJlineParser(new ShellStatementParser())).completer(NullCompleter.INSTANCE).history(new DefaultHistory()).expander(new JlineTerminal.EmptyExpander()).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.DISABLE_HIGHLIGHTER, true).variable("disable-completion", true).build();
        CypherShellTerminalBuilder.bindKeyPadKeys(reader);
        return new JlineTerminal(reader, this.isInteractive, this.logger, this.simplePromptSupplier);
    }

    public static CypherShellTerminalBuilder terminalBuilder() {
        return new CypherShellTerminalBuilder();
    }

    private static void bindKeyPadKeys(LineReader lineReader) {
        KeyMap<Binding> keyMap = lineReader.getKeyMaps().get("main");
        keyMap.bind((Binding)new Macro(KeyMap.translate(".")), (CharSequence)KeyMap.translate("^[On"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("^M")), (CharSequence)KeyMap.translate("^[OM"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("0")), (CharSequence)KeyMap.translate("^[Op"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("1")), (CharSequence)KeyMap.translate("^[Oq"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("2")), (CharSequence)KeyMap.translate("^[Or"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("3")), (CharSequence)KeyMap.translate("^[Os"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("4")), (CharSequence)KeyMap.translate("^[Ot"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("5")), (CharSequence)KeyMap.translate("^[Ou"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("6")), (CharSequence)KeyMap.translate("^[Ov"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("7")), (CharSequence)KeyMap.translate("^[Ow"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("8")), (CharSequence)KeyMap.translate("^[Ox"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("9")), (CharSequence)KeyMap.translate("^[Oy"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("+")), (CharSequence)KeyMap.translate("^[Ol"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("-")), (CharSequence)KeyMap.translate("^[OS"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("*")), (CharSequence)KeyMap.translate("^[OR"));
        keyMap.bind((Binding)new Macro(KeyMap.translate("/")), (CharSequence)KeyMap.translate("^[OQ"));
        keyMap.bind((Binding)new Reference("beginning-of-line"), (CharSequence)KeyMap.translate("\u001b[1~"));
        keyMap.bind((Binding)new Reference("end-of-line"), (CharSequence)KeyMap.translate("\u001b[4~"));
    }
}

