/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.virtual.ErrorValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class VirtualValues {
    public static final MapValue EMPTY_MAP = MapValue.EMPTY;
    public static final ListValue EMPTY_LIST = new ListValue.ArrayListValue(new AnyValue[0], 0L, ValueRepresentation.UNKNOWN);

    private VirtualValues() {
    }

    public static ListValue list(AnyValue ... values) {
        long payloadSize = 0L;
        ValueRepresentation representation = null;
        for (AnyValue value : values) {
            payloadSize += value.estimatedHeapUsage();
            if (value.valueRepresentation() == representation) continue;
            representation = representation == null ? value.valueRepresentation() : representation.coerce(value.valueRepresentation());
        }
        return new ListValue.ArrayListValue(values, payloadSize, representation == null ? ValueRepresentation.UNKNOWN : representation);
    }

    public static ListValue fromList(List<AnyValue> values) {
        long payloadSize = 0L;
        ValueRepresentation representation = null;
        for (AnyValue value : values) {
            payloadSize += value.estimatedHeapUsage();
            representation = representation == null ? value.valueRepresentation() : representation.coerce(value.valueRepresentation());
        }
        return new ListValue.JavaListListValue(values, payloadSize, representation == null ? ValueRepresentation.UNKNOWN : representation);
    }

    public static ListValue range(long start, long end, long step) {
        return new ListValue.IntegralRangeListValue(start, end, step);
    }

    public static ListValue fromArray(ArrayValue arrayValue) {
        return new ListValue.ArrayValueListValue(arrayValue);
    }

    public static ListValue concat(ListValue ... lists) {
        return new ListValue.ConcatList(lists);
    }

    public static MapValue map(String[] keys, AnyValue[] values) {
        assert (keys.length == values.length);
        long payloadSize = 0L;
        HashMap<String, AnyValue> map = new HashMap<String, AnyValue>((int)((float)keys.length / 0.75f + 1.0f));
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            AnyValue value = values[i];
            map.put(key, value);
            payloadSize += HeapEstimator.sizeOf(key) + value.estimatedHeapUsage();
        }
        return new MapValue.MapWrappingMapValue(map, payloadSize);
    }

    public static MapValue fromMap(Map<String, AnyValue> map, long mapSize, long payloadSize) {
        return new MapValue.MapWrappingMapValue(map, mapSize, payloadSize);
    }

    public static ErrorValue error(Exception e) {
        return new ErrorValue(e);
    }

    public static NodeReference node(long id) {
        return new NodeReference(id);
    }

    public static RelationshipReference relationship(long id) {
        return new RelationshipReference(id);
    }

    public static RelationshipReference relationship(long id, long startNode, long endNode) {
        return new RelationshipReference(id, startNode, endNode);
    }

    public static RelationshipReference relationship(long id, long startNode, long endNode, int type) {
        return new RelationshipReference(id, startNode, endNode, type);
    }

    public static PathReference pathReference(long[] nodes, long[] relationships) {
        assert (nodes != null);
        assert (relationships != null);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        assert (nodes.length == relationships.length + 1);
        return new PathReference(nodes, relationships);
    }

    public static PathReference pathReference(VirtualNodeValue[] nodes, VirtualRelationshipValue[] relationships) {
        int i;
        assert (nodes != null);
        assert (relationships != null);
        assert (nodes.length == relationships.length + 1);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        long[] nodeIds = new long[nodes.length];
        long[] relIds = new long[relationships.length];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = nodes[i].id();
        }
        for (i = 0; i < relationships.length; ++i) {
            relIds[i] = relationships[i].id();
        }
        return new PathReference(nodeIds, relIds);
    }

    public static PathValue path(NodeValue[] nodes, RelationshipValue[] relationships) {
        int i;
        assert (nodes != null);
        assert (relationships != null);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        long payloadSize = 0L;
        assert (nodes.length == relationships.length + 1);
        for (i = 0; i < relationships.length; ++i) {
            payloadSize += nodes[i].estimatedHeapUsage() + relationships[i].estimatedHeapUsage();
        }
        return new PathValue.DirectPathValue(nodes, relationships, payloadSize += nodes[i].estimatedHeapUsage());
    }

    public static PathValue path(NodeValue[] nodes, RelationshipValue[] relationships, long payloadSize) {
        assert (nodes != null);
        assert (relationships != null);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        return new PathValue.DirectPathValue(nodes, relationships, payloadSize);
    }

    public static NodeValue nodeValue(long id, TextArray labels, MapValue properties) {
        return new NodeValue.DirectNodeValue(id, labels, properties);
    }

    public static NodeValue nodeValue(long id, TextArray labels, MapValue properties, boolean isDeleted) {
        return new NodeValue.DirectNodeValue(id, labels, properties, isDeleted);
    }

    public static RelationshipValue relationshipValue(long id, VirtualNodeValue startNode, VirtualNodeValue endNode, TextValue type, MapValue properties) {
        return new RelationshipValue.DirectRelationshipValue(id, startNode, endNode, type, properties);
    }

    public static RelationshipValue relationshipValue(long id, VirtualNodeValue startNode, VirtualNodeValue endNode, TextValue type, MapValue properties, boolean isDeleted) {
        return new RelationshipValue.DirectRelationshipValue(id, startNode, endNode, type, properties, isDeleted);
    }
}

