/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.graphdb.schema.AnalyzerProvider;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.service.Services;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

final class FulltextIndexSettings {
    private FulltextIndexSettings() {
    }

    static Analyzer createAnalyzer(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        Analyzer analyzer;
        TextValue analyzerName = (TextValue)descriptor.getIndexConfig().get(FulltextIndexSettingsKeys.ANALYZER);
        if (analyzerName == null) {
            throw new RuntimeException("Index has no analyzer configured: " + descriptor.userDescription(tokenNameLookup));
        }
        try {
            AnalyzerProvider analyzerProvider = (AnalyzerProvider)Services.loadOrFail(AnalyzerProvider.class, (String)analyzerName.stringValue());
            analyzer = analyzerProvider.createAnalyzer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create fulltext analyzer: " + String.valueOf(analyzerName), e);
        }
        Objects.requireNonNull(analyzer, "The '" + String.valueOf(analyzerName) + "' analyzer provider returned a null analyzer.");
        return analyzer;
    }

    static String[] createPropertyNames(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        int[] propertyIds = descriptor.schema().getPropertyIds();
        String[] propertyNames = new String[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            propertyNames[i] = tokenNameLookup.propertyKeyGetName(propertyIds[i]);
        }
        return propertyNames;
    }

    static boolean isEventuallyConsistent(IndexDescriptor index) {
        BooleanValue eventuallyConsistent = (BooleanValue)index.getIndexConfig().getOrDefault(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, (Value)BooleanValue.FALSE);
        return eventuallyConsistent.booleanValue();
    }
}

